#! @SHELL@
# =============================================================================
#
# = DESCRIPTION
#     Script to combine class2info and info2mml.
#
# = AUTHOR(S)
#     Graham Dumpleton
# 
# = COPYRIGHT
#     Copyright 1991 OTC LIMITED
#     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
#
# =============================================================================

OSE_HOST=@OSE_HOST@

OSE_RELEASE_NAME=@OSE_RELEASE_NAME@
export OSE_RELEASE_NAME

OSE_ROOT=${OSE_ROOT-@OSE_ROOT@}
export OSE_ROOT

OSE_VERSION_ROOT=$OSE_ROOT/$OSE_RELEASE_NAME
export OSE_VERSION_ROOT

BINDIR="$OSE_VERSION_ROOT/$OSE_HOST/bin"
LIBDIR=${CLASSINFOLIBDIR-"$OSE_VERSION_ROOT/lib"}

CLASS2INFO="$BINDIR/class2info@CMDEXT@"
INFO2MAN="$BINDIR/info2mml@CMDEXT@"

#
# Error.
#
ERROR()
{
  echo "`basename $0`: $1" >&2
  shift
  while test $# != "0"
  do
    echo $1 >&2
    shift
  done
  exit 1
}

#
# Usage message.
#
USAGE()
{
  ERROR "Usage: `basename $0` files"
} 

#
# Check usage.
#
if test "$#" = "0"
then
  USAGE
fi

while test "$#" != "0"
do
  $CLASS2INFO $1
  if test "$?" != "0"
  then
    exit 1
  fi
  file=`basename $1`
  base="`echo $file | sed -e 's/\..*$//'`"
  if test -f "$base.ci"
  then
    $INFO2MAN $base.ci
    rm -f $base.ci
  fi
  shift
done
