#! @SHELL@
# =============================================================================
#
# = DESCRIPTION
#     Front end to awk script for generating manual pages from classinfo
#     files.
#
# = AUTHOR(S)
#     Graham Dumpleton
# 
# = COPYRIGHT
#     Copyright 1991 OTC LIMITED
#     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
#
# =============================================================================

OSE_HOST=@OSE_HOST@

OSE_RELEASE_NAME=@OSE_RELEASE_NAME@
export OSE_RELEASE_NAME

OSE_ROOT=${OSE_ROOT-@OSE_ROOT@}
export OSE_ROOT

OSE_VERSION_ROOT=$OSE_ROOT/$OSE_RELEASE_NAME
export OSE_VERSION_ROOT

BINDIR="$OSE_VERSION_ROOT/$OSE_HOST/bin"
LIBDIR=${CLASSINFOLIBDIR-"$OSE_VERSION_ROOT/lib"}

AWK="${AWK-@AWK@}"

if test "$AWK" = "gawk"
then
  VARG="-v"
fi

EXT="3"

#
# Error.
#
ERROR()
{
  echo "`basename $0`: $1" >&2
  shift
  while test $# != "0"
  do
    echo $1 >&2
    shift
  done
  exit 1
}

#
# Usage message.
#
USAGE()
{
  ERROR "Usage: `basename $0` file.ci"
} 

#
# Check usage.
#
if test $# != "1" -o "'basename $1 .ci'" = "$1"
then
  USAGE
fi

#
# Check for awk file etc.
#
INFO2MAN=$LIBDIR/info2doc.awk
MANFMT=$LIBDIR/info2doc.fmt

if test ! -f $INFO2MAN
then
  ERROR "Can't find $INFO2MAN"
fi

if test ! -f $MANFMT
then
  ERROR "Can't find $MANFMT"
fi

ADTS=`$AWK '
BEGIN {
  FS="\n"; RS=""
}
$1 ~ "^(CLASS|STRUCT|UNION)$" && $2 !~ "(::|<)" {
  printf( "%s\n", $2 )
}
$1 ~ "^TEMPLATE$" && $3 !~ "::" {
  printf( "%s\n", $3 )
}' $1`

if test ! -z "$ADTS"
then
  for ADT in $ADTS
  do
    echo "$ADT"

    $AWK -f $INFO2MAN $VARG pass=0 $VARG device=troff $VARG infile=$1 \
     $VARG class=$ADT $MANFMT $MANFMT > $ADT.$EXT
  done
fi
