#! @SHELL@
# =============================================================================
#
# = DESCRIPTION
#     Script to combine class2info and info2src.
#
# = AUTHOR(S)
#     Graham Dumpleton
# 
# = COPYRIGHT
#     Copyright 1991 OTC LIMITED
#     Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
#
# =============================================================================

OSE_HOST=@OSE_HOST@

OSE_RELEASE_NAME=@OSE_RELEASE_NAME@
export OSE_RELEASE_NAME

OSE_ROOT=${OSE_ROOT-@OSE_ROOT@}
export OSE_ROOT

OSE_VERSION_ROOT=$OSE_ROOT/$OSE_RELEASE_NAME
export OSE_VERSION_ROOT

BINDIR="$OSE_VERSION_ROOT/$OSE_HOST/bin"
LIBDIR=${CLASSINFOLIBDIR-"$OSE_VERSION_ROOT/lib"}

AWK="@AWK@"

#
# Error.
#
ERROR()
{
  echo "`basename $0`: $1" >&2
  shift
  while test $# != "0"
  do
    echo $1 >&2
    shift
  done
  exit 1
}

#
# Usage message.
#
USAGE()
{
  ERROR "Usage: `basename $0` file.ci"
} 

if test $# != "1" -o "'basename $1 .ci'" = "$1"
then
  USAGE
fi

#
# Check for awk file.
#
INFO2SRC=$LIBDIR/info2src.awk

if test ! -f $INFO2SRC
then
  ERROR "Can't find $INFO2SRC"
fi

$AWK -f $INFO2SRC $1
