#! @SHELL@

OSE_HOST=@OSE_HOST@

OSE_RELEASE_NAME=@OSE_RELEASE_NAME@
export OSE_RELEASE_NAME

OSE_ROOT=${OSE_ROOT-@OSE_ROOT@}
export OSE_ROOT

OSE_VERSION_ROOT=$OSE_ROOT/$OSE_RELEASE_NAME
export OSE_VERSION_ROOT

BINDIR="$OSE_VERSION_ROOT/$OSE_HOST/bin"
LIBDIR=${CLASSINFOLIBDIR-"$OSE_VERSION_ROOT/lib"}

#
# Error.
#
ERROR()
{
  echo "`basename $0`: $1" >&2
  shift
  while test $# != "0"
  do
    echo $1 >&2
    shift
  done
  exit 1
}

#
# Usage message.
#
USAGE()
{
  ERROR "Usage: `basename $0` files"
}

#
# Check usage.
#
if test "$#" = "0"
then
  USAGE
fi

while test "$#" != "0"
do
  INPUT=$1
  BASENAME=`basename $INPUT | sed -e 's/\(.*\)\.[^.]*$/\1/'`
  OUTPUT=${BASENAME}.html

  if test -f ${INPUT}
  then
    echo ${BASENAME}
    cat ${INPUT} | 
	sed  -e 's/\\-/-/g' \
	     -e 's/\\ / /g' \
	     -e 's/\\[0&]/  /g' \
	     -e 's/&/\&amp;/g' \
	     -e 's/</\&lt;/g' \
	     -e 's/>/\&gt;/g' \
	     -e 's/\\|//g' \
	     -e 's/\\e/\\/g'     |
	/bin/nawk -f ${LIBDIR}/man2html1.awk | 
	 sed -e 's^\\fB\([^\\]*\)\\fR^<B>\1</B></I>^g' \
	    -e 's^\\f(CO\(.[^\\]*\)\\fR^<CODE>\1</CODE>^g' \
	    -e 's^\\fI\(.[^\\]*\)\\fR^<I>\1</I></B>^g' \
	    -e 's^\\fB^<B>^g' \
	    -e 's^\\f(CO^<CODE>^g' \
	    -e 's^\\fI^<I>^g' \
	    -e 's^\\f[RP]^</B></I></CODE>^g' \
	    -e 's/^.[LP]P/<P>/' \
	    -e 's/^.br/<BR>/' \
	    -e 's/^\.DS.*/<pre>/' \
	    -e 's$^\.DE.*$</pre>$' \
	    -e 's/^\.nf */<pre>/' \
	    -e 's$^\.fi *$</pre>$' \
	    -e 's$^\.BE *$</pre><HR>$' \
	    -e 's/^\.RS.*/<UL>/' \
	    -e 's$^\.RE.*$</UL>$' \
	    -e 's^\.SH *"*\([^"]*\)"*^</pre><H2>\1</H2>^' \
	    -e '/^\.[a-zA-Z]*.*/d'	|
	/bin/nawk -f ${LIBDIR}/man2html2.awk > ${OUTPUT}
  fi
  shift
done
