#! /bin/sh

#
# = AUTHOR(S)
#     Graham Dumpleton
#
# = COPYRIGHT
#     Copyright 1994 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
#

OSE_ROOT=${OSE_ROOT-@OSE_ROOT@}
export OSE_ROOT

COPYINGFILES=`ls ${OSE_ROOT}/*/COPYING 2>/dev/null`

if test ! -z "${COPYINGFILES}"
then
  for v in ${COPYINGFILES}
  do
    OSE_HOME=`dirname $v`
    OSE_RELEASE_NAME=`basename ${OSE_HOME}`
    echo "Release: ${OSE_RELEASE_NAME}"
    echo
    VERSIONFILES=`ls ${OSE_HOME}/*/VERSION 2>/dev/null`

    if test ! -z "${VERSIONFILES}"
    then
      for i in ${VERSIONFILES}
      do
	VERSION=`cat $i`
	HOSTDIR=`dirname $i`
	HOST=`basename ${HOSTDIR}`
	echo "  Host: ${HOST}"
	echo "  Version: ${VERSION}"
	echo
	OSELIBS=`ls ${OSE_HOME}/${HOST}/lib/*/libOSE.a 2>/dev/null`
	if test ! -z "${OSELIBS}"
	then
	  for j in ${OSELIBS}
	  do
	    LIBDIR=`dirname $j`
	    COMPILER=`basename ${LIBDIR}`
	    OTCLIBS=`ls ${LIBDIR}/libOTC_*[0-9].a 2>/dev/null | grep -v pure`
	    if test -z "$OTCLIBS"
	    then
	      OTCLIBS=`ls ${LIBDIR}/libOTC_*.a 2>/dev/null | grep -v pure`
	      VARIANTS=`echo ${OTCLIBS} | \
	       sed -e 's/[^ ]*libOTC_[^ ]*_[^ ]*_//g' -e 's/\.a//g'`
	    else
	      VARIANTS=`echo ${OTCLIBS} | \
	       sed -e 's/[^ ]*libOTC_//g' -e 's/_[^ ]*\.a//g'`
	    fi
	    if test ! -z "${VARIANTS}"
	    then
	      echo "    Compiler: ${COMPILER}"
	      echo "    Variants: ${VARIANTS}"
	      OTKLIBS=`ls ${LIBDIR}/libOTK*.a 2>/dev/null`
	      if test ! -z "${OTKLIBS}"
	      then
		echo "    Libraries: OTCLIB OUXLIB OTKLIB"
	      else
		echo "    Libraries: OTCLIB OUXLIB"
	      fi
	      echo
	    fi
	  done
	else
	  echo "    only makeit is available"
	  echo
	fi
      done
    else
      echo "  old installation format - information unavailable"
      echo
    fi
  done
fi
