#ifndef CELL_HH
#define CELL_HH
/*
// ============================================================================
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1991 OTC LIMITED
//
// ============================================================================
*/

#include "cellid.hh"
#include "phoneid.hh"
#include "mobileid.hh"
#include "freqid.hh"

#include <OTC/collctn/baseactn.hh>
#include <OTC/collctn/uniqmap.hh>
#include <OTC/collctn/set.hh>
#include <OTC/refcnt/resource.hh>

/* ------------------------------------------------------------------------- */

#ifdef __OSE_TEMPLATES__
OSE_TEMPLATE OTC_UniqMap<UQ_FreqId,UQ_MobileId>;
OSE_TEMPLATE OTC_Set<UQ_MobileId>;
OSE_TEMPLATE OTC_Set<UQ_FreqId>;
#endif

class UQ_Cell : public OTC_Resource
    // = TITLE
    //     Class representing a cell withing the mobile phone system.
    //
    // = DESCRIPTION
    //     A cell corresponds to some geographical area.
{
  public:

			~UQ_Cell();

    // = INIT

			UQ_Cell(
			 UQ_CellId const& anId,
			 OTC_Set<UQ_FreqId> const& theFreqs
			);
				// Initialises the cell with identifier
				// <anID> and allocates the cell the
				// frequencies provided in <theFreqs>.

    // = OPERATIONS
    //     Following return <0> or <-1> depending on whether the
    //     operation was successful or not. The return of <-1> can be a
    //     result of either a precondition, postcondition or call to other
    //     operation failing.

    int			page(UQ_MobileId const& mid);

    int			bePagedSeized(UQ_MobileId const& mid);

    int			beCallSeized(
			 UQ_MobileId const& mid,
			 UQ_PhoneId const& pid
			);

    int			tune(UQ_MobileId const& mid, UQ_FreqId& fid);

    int			handOff(UQ_MobileId const& mid);

    int			handOn(UQ_MobileId const& mid, UQ_FreqId& fid);

    int			disconnect(UQ_MobileId const& mid);

    // = INVARIANT

    OTC_Boolean		invariant() const;
				// Returns <OTCLIB_TRUE> if the invariant
				// conditions of a cell are satisified.

    // = ENQUIRY

    UQ_CellId const&	id() const
				{ return myId; }

    OTC_Set<UQ_FreqId> const&	freqs() const
				{ return myFreqs; }

    OTC_Set<UQ_MobileId> const&	access() const
				{ return myAccess; }

    OTC_UniqMap<UQ_FreqId,UQ_MobileId> const&	alloc() const
				{ return myAlloc; }

    void		dump(ostream& outs) const;

  private:

    // = DATA

    UQ_CellId const	myId;

    OTC_Set<UQ_FreqId> const	myFreqs;

    OTC_Set<UQ_MobileId>	myAccess;

    OTC_UniqMap<UQ_FreqId,UQ_MobileId>	myAlloc;
};

/* ------------------------------------------------------------------------- */

#ifdef __OSE_TEMPLATES__
OSE_MARK_TEMPLATE OTC_BaseActions<UQ_Cell*>;
#endif

class OTC_BaseActions<UQ_Cell*>
{
  public:

    static UQ_Cell*	add(UQ_Cell* theCell)
				{
				  theCell->reference();
				  return theCell;
				}

    static void		remove(UQ_Cell* theCell)
				{ theCell->unReference(); }
};

/* ------------------------------------------------------------------------- */

#endif /* CELL_HH */
