#ifndef CELLID_HH
#define CELLID_HH
/*
// ============================================================================
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1991 OTC LIMITED
//
// ============================================================================
*/

#include <OTC/collctn/set.hh>

#include <iostream.h>

/* ------------------------------------------------------------------------- */

#ifdef __OSE_TEMPLATES__
OSE_TEMPLATE OTC_Set<int>;
#endif

class UQ_CellId
{
  public:

			UQ_CellId()
			 : myId(0) {}

			UQ_CellId(int anId)
			 : myId(anId) {}

			UQ_CellId(UQ_CellId const& theCellId)
			 : myId(theCellId.myId) {}

			~UQ_CellId();

			operator int() const
				{ return myId; }

    UQ_CellId&		operator=(UQ_CellId const& theCellId)
				{ myId = theCellId.myId; return *this; }

    static UQ_CellId	any();

    static u_int	population()
				{ return globIds.population(); }

    static OTC_Boolean	contains(UQ_CellId const& cid)
				{
				  int anId = cid;
				  return globIds.contains(anId);
				}

			UQ_CellId(char const* theFile);

  private:

    static UQ_CellId	globId;

    static OTC_Set<int>	globIds;

    static OTC_Iterator<int>	globIter;

    int			myId;
};

/* ------------------------------------------------------------------------- */

extern ostream& operator<<(ostream& outs, UQ_CellId const& theCid);
extern istream& operator>>(istream& ins, UQ_CellId& theCid);

/* ------------------------------------------------------------------------- */

#endif /* CELLID_HH */
