#ifndef FREQID_HH
#define FREQID_HH
/*
// ============================================================================
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1991 OTC LIMITED
//
// ============================================================================
*/

#include <OTC/collctn/set.hh>

#include <iostream.h>

/* ------------------------------------------------------------------------- */

#ifdef __OSE_TEMPLATES__
OSE_TEMPLATE OTC_Set<int>;
#endif

class UQ_FreqId
{
  public:

			UQ_FreqId()
			 : myId(0) {}

			UQ_FreqId(int anId)
			 : myId(anId) {}

			UQ_FreqId(UQ_FreqId const& theUQ_FreqId)
			 : myId(theUQ_FreqId.myId) {}

			~UQ_FreqId();

			operator int() const
				{ return myId; }

    UQ_FreqId&		operator=(UQ_FreqId const& theUQ_FreqId)
				{ myId = theUQ_FreqId.myId; return *this; }

    static UQ_FreqId	any();

    static OTC_Boolean	contains(UQ_FreqId const& fid)
				{
				  int anId = fid;
				  return globIds.contains(anId);
				}

			UQ_FreqId(char const* theFile);

  private:

    static UQ_FreqId	globId;

    static OTC_Set<int>	globIds;

    static OTC_Iterator<int>	globIter;

    int			myId;
};

/* ------------------------------------------------------------------------- */

extern ostream& operator<<(ostream& outs, UQ_FreqId const& theFid);
extern istream& operator>>(istream& ins, UQ_FreqId& theFid);

/* ------------------------------------------------------------------------- */

#endif /* FREQID_HH */
