#ifndef MOBILE_HH
#define MOBILE_HH
/*
// ============================================================================
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1991 OTC LIMITED
//
// ============================================================================
*/

#include "cellid.hh"
#include "mobileid.hh"
#include "freqid.hh"
#include "phoneid.hh"

#include <OTC/collctn/baseactn.hh>
#include <OTC/refcnt/resource.hh>

/* ------------------------------------------------------------------------- */

#ifdef __OSE_TEMPLATES__
OSE_TEMPLATE OTC_Set<UQ_CellId>;
OSE_TEMPLATE OTC_Set<UQ_FreqId>;
#endif

class UQ_Mobile : public OTC_Resource
    // = TITLE
    //     Class representing a mobile phone.
{
  public:

    enum State
	// = TITLE
	//     Enumeration for the states of a mobile.
    {
      IDLE=0,
      PAGED=1,
      PAGED_ACCESS=2,
      CALL_ACCESS=3,
      RINGING=4,
      OFFHOOK=5
    };

  public:

			UQ_Mobile(UQ_Mobile const& theMobile);
				// Copy constructor.

			~UQ_Mobile();

    // = INIT

			UQ_Mobile(UQ_MobileId const& anId);
				// Initialises the mobile with identifier
				// <anId>, leaving the mobile in the <IDLE>
				// state.

    // = OPERATIONS
    //     Following return <0> or <-1> depending on whether the
    //     operation was successful or not. The return of <-1> can be a
    //     result of either a precondition, postcondition or call to other
    //     operation failing.

    int			cell(UQ_CellId& cid) const;

    int			locate(UQ_CellId& cid);

    int			bePaged();

    int			pagedSeize();

    int			callSeize(UQ_PhoneId& pid);

    int			beTuned(UQ_FreqId const& fid);

    int			answer();

    int			beHandedOver(
			 UQ_CellId const& cid,
			 UQ_FreqId const& fid
			);

    int			beDisconnected();

    // = INVARIANT

    OTC_Boolean		invariant() const;
				// Returns <OTCLIB_TRUE> if the invariant
				// conditions of a mobile are satisfied.

    // = ENQUIRY

    State		state() const
				{ return myState; }
				// Returns the state of the mobile.

    UQ_MobileId const&	id() const
				{ return myId; }
				// Returns the identifier of the mobile.

    UQ_FreqId		freq() const;
				// Returns the frequency allocated to the
				// mobile, or <0> if none is allocated.

    void		dump(ostream& outs) const;
				// Dumps information about the instance.

  private:

    // = DATA

    UQ_MobileId const	myId;
				// Identifier for mobile.

    State		myState;
				// The state of the mobile.

    OTC_Set<UQ_FreqId>	myFreq;
				// A set of frequencies which is either empty
				// (when no frequency has been allocated to
				// the mobile) or contains just that
				// frequency allocated to the mobile by the
				// corresponding cell.

    OTC_Set<UQ_CellId>	myCell;
};

/* ------------------------------------------------------------------------- */

#ifdef __OSE_TEMPLATES__
OSE_MARK_TEMPLATE OTC_BaseActions<UQ_Mobile*>;
#endif

class OTC_BaseActions<UQ_Mobile*>
    // = TITLE
    //     Base actions for Mobile contained in collection.
{
  public:

    static UQ_Mobile*	add(UQ_Mobile* theMobile)
				{
				  theMobile->reference();
				  return theMobile;
				}
				// Increment reference count.

    static void		remove(UQ_Mobile* theMobile)
				{ theMobile->unReference(); }
				// Decrement reference count.
};

/* ------------------------------------------------------------------------- */

#endif /* MOBILE_HH */
