#ifndef MOBILEID_HH
#define MOBILEID_HH
/*
// ============================================================================
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1991 OTC LIMITED
//
// ============================================================================
*/

#include <OTC/collctn/set.hh>

#include <iostream.h>

/* ------------------------------------------------------------------------- */

#ifdef __OSE_TEMPLATES__
OSE_TEMPLATE OTC_Set<int>;
#endif

class UQ_MobileId
{
  public:

			UQ_MobileId()
			 : myId(0) {}

			UQ_MobileId(int anId)
			 : myId(anId) {}

			UQ_MobileId(UQ_MobileId const& theUQ_MobileId)
			 : myId(theUQ_MobileId.myId) {}

			~UQ_MobileId();

			operator int() const
				{ return myId; }

    UQ_MobileId&		operator=(UQ_MobileId const& theUQ_MobileId)
				{ myId = theUQ_MobileId.myId; return *this; }

    static UQ_MobileId	any();

    static u_int	population()
				{ return globIds.population(); }

    static OTC_Boolean	contains(UQ_MobileId const& mid)
				{
				  int anId = mid;
				  return globIds.contains(anId);
				}

			UQ_MobileId(char const* theFile);

  private:

    static UQ_MobileId	globId;

    static OTC_Set<int>	globIds;

    static OTC_Iterator<int>	globIter;

    int			myId;
};

/* ------------------------------------------------------------------------- */

extern ostream& operator<<(ostream& outs, UQ_MobileId const& theMid);
extern istream& operator>>(istream& ins, UQ_MobileId& theMid);

/* ------------------------------------------------------------------------- */

#endif /* MOBILEID_HH */
