#ifndef MOBILES_HH
#define MOBILES_HH
/*
// ============================================================================
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1991 OTC LIMITED
//
// ============================================================================
*/

#include "mobile.hh"

#include <OTC/collctn/map.hh>

/* ------------------------------------------------------------------------- */

#ifdef __OSE_TEMPLATES__
OSE_TEMPLATE OTC_Map<UQ_MobileId,UQ_Mobile*>;
#endif

class UQ_Mobiles
{
  public:

			UQ_Mobiles();

			~UQ_Mobiles();

			UQ_Mobiles(UQ_Mobiles const& theUQ_Mobiles);

    int			cell(UQ_MobileId const& mid, UQ_CellId& cid);

    int			bePaged(UQ_MobileId const& mid);

    int			locate(UQ_MobileId const& mid, UQ_CellId& cid);

    int			pagedSeize(UQ_MobileId const& mid);

    int			callSeize(
			 UQ_MobileId const& mid,
			 UQ_PhoneId& pid
			);

    int			beTuned(UQ_MobileId const& mid, UQ_FreqId const& fid);

    int			answer(UQ_MobileId const& mid);

    int			beHandedOver(
			 UQ_MobileId const& mid,
			 UQ_CellId const& cid,
			 UQ_FreqId const& fid
			);

    int			beDisconnected(UQ_MobileId const& mid);

    OTC_Boolean		invariant() const;

    void		dump(ostream& outs) const;

  private:

    OTC_Map<UQ_MobileId,UQ_Mobile*>	myMobiles;
};

/* ------------------------------------------------------------------------- */

#endif /* MOBILES_HH */
