#ifndef MPS_HH
#define MPS_HH
/*
// ============================================================================
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1991 OTC LIMITED
//
// ============================================================================
*/

#include "mobiles.hh"
#include "cell.hh"
#include "cellid.hh"

#include <OTC/collctn/map.hh>

/* ------------------------------------------------------------------------- */

#ifdef __OSE_TEMPLATES__
OSE_TEMPLATE OTC_Map<UQ_CellId,UQ_Cell*>;
#endif

class UQ_MPS
{
  public:

			UQ_MPS();

			~UQ_MPS();

			UQ_MPS(UQ_MPS const& theMPS);

    int			allCellsPage(UQ_MobileId const& mid);

    int			page(UQ_MobileId const& mid);

    int			pagedSeize(UQ_MobileId const& mid, UQ_CellId& cid);

    int			callSeize(
			 UQ_MobileId const& mid,
			 UQ_CellId& cid,
			 UQ_PhoneId& pid
			);

    int			tune(
			 UQ_MobileId const& mid,
			 UQ_FreqId& fid
			);

    int			answer(UQ_MobileId const& mid);

    int			handOver(
			 UQ_MobileId const& mid,
			 UQ_CellId const& cid,
			 UQ_FreqId& fid
			);

    int			disconnect(UQ_MobileId const& mid);

    void		dump(ostream& outs) const;

  protected:

    OTC_Boolean		invariant() const;

  private:

    UQ_Mobiles		myMobiles;

    OTC_Map<UQ_CellId,UQ_Cell*>	myCells;
};

/* ------------------------------------------------------------------------- */

#endif /* MPS_HH */
