/*
// ============================================================================
//
// = AUTHOR(S)
//     Graham Dumpleton
//
// = COPYRIGHT
//     Copyright 1991 OTC LIMITED
//
// ============================================================================
*/

#include "mps.hh"
#include "prepost.hh"

#include <OTC/debug/tracer.hh>
#include <OTC/text/string.hh>

#include <strstream.h>

/* ------------------------------------------------------------------------- */

int execute(
 UQ_MPS& mps, OTC_String const& theName, OTC_String const& theArguments)
{
  OTCLIB_MARKBLOCK(UQ,"execute()");
  OTCLIB_TRACER(UQ) << "name = " << theName << endl;
  OTCLIB_TRACER(UQ) << "arguments = " << theArguments << endl;

  if (theName == "dump")
  {
    if (theArguments == "")
    {
      mps.dump(cout);
      return 0;
    }
  }
  else if (theName == "allCellsPage")
  {
    UQ_MobileId mid;
    strstream ss;
    ss << theArguments;
    ss >> mid;

    if (!ss.fail() && UQ_MobileId::contains(mid))
    {
      int res = mps.allCellsPage(mid);
      cout << "res = " << res << endl;
      cout << "mid = " << mid << endl;
      return res;
    }
  }
  else if (theName == "page")
  {
    UQ_MobileId mid;
    strstream ss;
    ss << theArguments;
    ss >> mid;

    if (!ss.fail() && UQ_MobileId::contains(mid))
    {
      int res = mps.page(mid);
      cout << "res = " << res << endl;
      cout << "mid = " << mid << endl;
      return res;
    }
  }
  else if (theName == "pagedSeize")
  {
    UQ_MobileId mid;
    strstream ss;
    ss << theArguments;
    ss >> mid;

    if (!ss.fail() && UQ_MobileId::contains(mid))
    {
      UQ_CellId cid;
      int res = mps.pagedSeize(mid,cid);
      cout << "res = " << res << endl;
      cout << "mid = " << mid << endl;
      cout << "cid = " << cid << endl;
      return res;
    }
  }
  else if (theName == "callSeize")
  {
    UQ_MobileId mid;
    strstream ss;
    ss << theArguments;
    ss >> mid;

    if (!ss.fail() && UQ_MobileId::contains(mid))
    {
      UQ_CellId cid;
      UQ_PhoneId pid;
      int res = mps.callSeize(mid,cid,pid);
      cout << "res = " << res << endl;
      cout << "mid = " << mid << endl;
      cout << "cid = " << cid << endl;
      cout << "pid = " << pid << endl;
      return res;
    }
  }
  else if (theName == "tune")
  {
    UQ_MobileId mid;
    strstream ss;
    ss << theArguments;
    ss >> mid;

    if (!ss.fail() && UQ_MobileId::contains(mid))
    {
      UQ_FreqId fid;
      int res = mps.tune(mid,fid);
      cout << "res = " << res << endl;
      cout << "mid = " << mid << endl;
      cout << "fid = " << fid << endl;
      return res;
    }
  }
  else if (theName == "answer")
  {
    UQ_MobileId mid;
    strstream ss;
    ss << theArguments;
    ss >> mid;

    if (!ss.fail() && UQ_MobileId::contains(mid))
    {
      int res = mps.answer(mid);
      cout << "res = " << res << endl;
      cout << "mid = " << mid << endl;
      return res;
    }
  }
  else if (theName == "handOver")
  {
    UQ_MobileId mid;
    UQ_CellId cid;
    strstream ss;
    ss << theArguments;
    ss >> mid >> cid;

    if (!ss.fail() && UQ_MobileId::contains(mid) && UQ_CellId::contains(cid))
    {
      UQ_FreqId fid;
      int res = mps.handOver(mid,cid,fid);
      cout << "res = " << res << endl;
      cout << "mid = " << mid << endl;
      cout << "cid1 = " << cid << endl;
      cout << "fid = " << fid << endl;
      return res;
    }
  }
  else if (theName == "disconnect")
  {
    UQ_MobileId mid;
    strstream ss;
    ss << theArguments;
    ss >> mid;

    if (!ss.fail() && UQ_MobileId::contains(mid))
    {
      int res = mps.disconnect(mid);
      cout << "res = " << res << endl;
      cout << "mid = " << mid << endl;
      return res;
    }
  }

  return -1;
}

main()
{
  OTCLIB_MARKBLOCK(UQ,"main()");

  // set_new_handler(otclib_new_handler);
  set_terminate(otclib_terminate_function);
  
  UQ_MPS mps;

  OTC_String line;
  OTC_String name;
  OTC_String arguments;

  while (cin.good())
  {
    cout << "mps> " << flush;
    line = OTC_String::getline(cin);
    if (!cin.fail())
    {
      arguments = "";
      line.trim();
      int index = line.index(' ');
      if (index != -1)
      {
	name = line.before(index);
	arguments = line.after(index);
      }
      else
      {
	name = line;
      }
      if (!name.isEmpty())
	if (execute(mps,name,arguments) == -1)
	  cout << "invalid command" << endl;
    }
  }

  return 0;
}

/* ------------------------------------------------------------------------- */
