#ifndef PHONEID_HH
#define PHONEID_HH
/*
// ============================================================================
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1991 OTC LIMITED
//
// ============================================================================
*/

#include <OTC/collctn/set.hh>

#include <iostream.h>

/* ------------------------------------------------------------------------- */

#ifdef __OSE_TEMPLATES__
OSE_TEMPLATE OTC_Set<int>;
#endif

class UQ_PhoneId
{
  public:

			UQ_PhoneId()
			 : myId(0) {}

			UQ_PhoneId(int anId)
			 : myId(anId) {}

			UQ_PhoneId(UQ_PhoneId const& theUQ_PhoneId)
			 : myId(theUQ_PhoneId.myId) {}

			~UQ_PhoneId();

			operator int() const
				{ return myId; }

    UQ_PhoneId&		operator=(UQ_PhoneId const& theUQ_PhoneId)
				{ myId = theUQ_PhoneId.myId; return *this; }

    static UQ_PhoneId	any();

    static OTC_Boolean	contains(UQ_PhoneId const& pid)
				{
				  int anId = pid;
				  return globIds.contains(anId);
				}

			UQ_PhoneId(char const* theFile);

  private:

    static UQ_PhoneId	globId;

    static OTC_Set<int>	globIds;

    static OTC_Iterator<int>	globIter;

    int			myId;
};

/* ------------------------------------------------------------------------- */

extern ostream& operator<<(ostream& outs, UQ_PhoneId const& thePid);
extern istream& operator>>(istream& ins, UQ_PhoneId& thePid);

/* ------------------------------------------------------------------------- */

#endif /* PHONEID_HH */
