#ifndef PREPOST_HH
#define PREPOST_HH
/*
// ============================================================================
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1991 OTC LIMITED
//
// ============================================================================
*/

#include <OTC/OTC.h>

#include <OTC/debug/tracetag.hh>

#include <iostream.h>

/* ------------------------------------------------------------------------- */

extern OTC_TraceTag& UQ_TRACETAG();

#define UQ UQ_TRACETAG()

#define UQ_PRE(mesg,ex) \
  if (ex) ; else \
  { \
    cout << "Precondition failed : " << mesg << endl; \
    return -1; \
  }

#define UQ_POST(mesg,ex) \
  if (ex) ; else \
  { \
    cout << "Precondition failed : " << mesg << endl; \
    return -1; \
  }

#define UQ_CALL(mesg,ex) \
  if ((ex) != -1) ; else \
  { \
    cout << "Call failed : " << mesg << endl; \
    return -1; \
  }

#define UQ_INVARIANT(mesg) \
  if (invariant() != OTCLIB_FALSE) ; else \
   OTCLIB_EXCEPTION("invariant failed - " mesg);

#define UQ_SUCCESS(mesg) \
  cout << "Operation succeeded - " << mesg << endl; \
  return 0;

/* ------------------------------------------------------------------------- */

#endif /* PREPOST_HH */
