/*
// ============================================================================
//
// = AUTHOR(S)
//     Graham Dumpleton
//
// = COPYRIGHT
//     Copyright 1991 OTC LIMITED
//
// ============================================================================
*/

#include "cellid.hh"
#include "prepost.hh"

#include <OTC/debug/tracer.hh>

#include <fstream.h>

/* ------------------------------------------------------------------------- */
OTC_Set<int> UQ_CellId::globIds;
OTC_Iterator<int> UQ_CellId::globIter = UQ_CellId::globIds.items();
UQ_CellId UQ_CellId::globId("cellid.dat");

/* ------------------------------------------------------------------------- */
UQ_CellId::UQ_CellId(char const* theFile)
{
  OTCLIB_MARKBLOCK(UQ,"CellId::CellId()");

  ifstream ins(theFile);

  while (ins.good())
  {
    int id;
    ins >> id;
    if (!ins.fail())
    {
      OTCLIB_ASSERT(id != 0);
      if (id != 0)
	globIds.add(id);
    }
  }
}

/* ------------------------------------------------------------------------- */
UQ_CellId::~UQ_CellId()
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
UQ_CellId UQ_CellId::any()
{
  globIter.next();
  if (!globIter.isValid())
    globIter.reset();

  OTCLIB_ASSERT(globIter.isValid());

  return globIter.item();
}

/* ------------------------------------------------------------------------- */
ostream& operator<<(ostream& outs, UQ_CellId const& theCid)
{
  outs << int(theCid);
  return outs;
}

/* ------------------------------------------------------------------------- */
istream& operator>>(istream& ins, UQ_CellId& theCid)
{
  int aCid = 0;
  ins >> aCid;
  theCid = aCid;
  return ins;
}

/* ------------------------------------------------------------------------- */
