/*
// ============================================================================
//
// = AUTHOR(S)
//     Graham Dumpleton
//
// = COPYRIGHT
//     Copyright 1991 OTC LIMITED
//
// ============================================================================
*/

#include "freqid.hh"
#include "prepost.hh"

#include <OTC/debug/tracer.hh>

#include <fstream.h>

/* ------------------------------------------------------------------------- */
OTC_Set<int> UQ_FreqId::globIds;
OTC_Iterator<int> UQ_FreqId::globIter = UQ_FreqId::globIds.items();
UQ_FreqId UQ_FreqId::globId("freqid.dat");

/* ------------------------------------------------------------------------- */
UQ_FreqId::UQ_FreqId(char const* theFile)
{
  OTCLIB_MARKBLOCK(UQ,"FreqId::FreqId()");

  ifstream ins(theFile);

  while (ins.good())
  {
    int id;
    ins >> id;
    if (!ins.fail())
    {
      OTCLIB_ASSERT(id != 0);
      if (id != 0)
	globIds.add(id);
    }
  }
}

/* ------------------------------------------------------------------------- */
UQ_FreqId::~UQ_FreqId()
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
UQ_FreqId UQ_FreqId::any()
{
  globIter.next();
  if (!globIter.isValid())
    globIter.reset();

  OTCLIB_ASSERT(globIter.isValid());

  return globIter.item();
}

/* ------------------------------------------------------------------------- */
ostream& operator<<(ostream& outs, UQ_FreqId const& theFid)
{
  outs << int(theFid);
  return outs;
}

/* ------------------------------------------------------------------------- */
istream& operator>>(istream& ins, UQ_FreqId& theFid)
{
  int aFid = 0;
  ins >> aFid;
  theFid = aFid;
  return ins;
}

/* ------------------------------------------------------------------------- */
