/*
// ============================================================================
//
// = AUTHOR(S)
//     Graham Dumpleton
//
// = COPYRIGHT
//     Copyright 1991 OTC LIMITED
//
// ============================================================================
*/

#include "mobileid.hh"
#include "prepost.hh"

#include <OTC/debug/tracer.hh>

#include <fstream.h>

/* ------------------------------------------------------------------------- */
OTC_Set<int> UQ_MobileId::globIds;
OTC_Iterator<int> UQ_MobileId::globIter = UQ_MobileId::globIds.items();
UQ_MobileId UQ_MobileId::globId("mobileid.dat");

/* ------------------------------------------------------------------------- */
UQ_MobileId::UQ_MobileId(char const* theFile)
{
  OTCLIB_MARKBLOCK(UQ,"MobileId::MobileId()");

  ifstream ins(theFile);

  while (ins.good())
  {
    int id;
    ins >> id;
    if (!ins.fail())
    {
      OTCLIB_ASSERT(id != 0);
      if (id != 0)
	globIds.add(id);
    }
  }
}

/* ------------------------------------------------------------------------- */
UQ_MobileId::~UQ_MobileId()
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
UQ_MobileId UQ_MobileId::any()
{
  globIter.next();
  if (!globIter.isValid())
    globIter.reset();

  OTCLIB_ASSERT(globIter.isValid());

  return globIter.item();
}

/* ------------------------------------------------------------------------- */
ostream& operator<<(ostream& outs, UQ_MobileId const& theMid)
{
  outs << int(theMid);
  return outs;
}

/* ------------------------------------------------------------------------- */
istream& operator>>(istream& ins, UQ_MobileId& theMid)
{
  int aMid = 0;
  ins >> aMid;
  theMid = aMid;
  return ins;
}

/* ------------------------------------------------------------------------- */
