/*
// ============================================================================
//
// = AUTHOR(S)
//     Graham Dumpleton
//
// = COPYRIGHT
//     Copyright 1991 OTC LIMITED
//
// ============================================================================
*/

#include "mobiles.hh"
#include "prepost.hh"

#include <OTC/debug/tracer.hh>

#include <string.h>
#include <strstream.h>

/* ------------------------------------------------------------------------- */
UQ_Mobiles::UQ_Mobiles()
{
  OTCLIB_MARKBLOCK(UQ,"Mobiles::Mobiles()");

  UQ_MobileId mid1 = UQ_MobileId::any();
  UQ_MobileId mid2 = UQ_MobileId::any();
  while (mid1 != mid2)
  {
    UQ_Mobile* aMobile = new UQ_Mobile(mid2);
    OTCLIB_ASSERT(aMobile != 0);
    myMobiles.add(mid2,aMobile);
    mid2 = UQ_MobileId::any();
  }
  UQ_Mobile* aMobile = new UQ_Mobile(mid2);
  OTCLIB_ASSERT(aMobile != 0);
  myMobiles.add(mid2,aMobile);

  UQ_INVARIANT("Mobiles::Mobiles()");
}

/* ------------------------------------------------------------------------- */
UQ_Mobiles::UQ_Mobiles(UQ_Mobiles const& theMobiles)
  : myMobiles(theMobiles.myMobiles)
{
  OTCLIB_MARKBLOCK(UQ,"Mobiles::Mobiles()");

  UQ_INVARIANT("Mobiles::Mobiles()");
}

/* ------------------------------------------------------------------------- */
UQ_Mobiles::~UQ_Mobiles()
{
  OTCLIB_MARKBLOCK(UQ,"Mobiles::~Mobiles()");
}

/* ------------------------------------------------------------------------- */
int UQ_Mobiles::cell(UQ_MobileId const& mid, UQ_CellId& cid)
{
  OTCLIB_MARKBLOCK(UQ,"Mobiles::cell()");

  OTC_Boolean pre1 = myMobiles.contains(mid);
  UQ_PRE("Mobiles::cell()",pre1);

  int call1 = myMobiles.item(mid)->cell(cid);
  UQ_CALL("Mobiles::cell()",call1);

  UQ_INVARIANT("Mobiles::cell()");

  UQ_SUCCESS("Mobiles::cell()");
}

/* ------------------------------------------------------------------------- */
int UQ_Mobiles::bePaged(UQ_MobileId const& mid)
{
  OTCLIB_MARKBLOCK(UQ,"Mobiles::bePaged()");

  OTC_Boolean pre1 = myMobiles.contains(mid);
  UQ_PRE("Mobiles::bePaged()",pre1);

  int call1 = myMobiles.item(mid)->bePaged();
  UQ_CALL("Mobiles::bePaged()",call1);

  UQ_INVARIANT("Mobiles::bePaged()");

  UQ_SUCCESS("Mobiles::bePaged()");
}

/* ------------------------------------------------------------------------- */
int UQ_Mobiles::locate(UQ_MobileId const& mid, UQ_CellId& cid)
{
  OTCLIB_MARKBLOCK(UQ,"Mobiles::locate()");

  OTC_Boolean pre1 = myMobiles.contains(mid);
  UQ_PRE("Mobiles::locate()",pre1);

  int call1 = myMobiles.item(mid)->locate(cid);
  UQ_CALL("Mobiles::locate()",call1);

  UQ_INVARIANT("Mobiles::locate()");

  UQ_SUCCESS("Mobiles::locate()");
}

/* ------------------------------------------------------------------------- */
int UQ_Mobiles::pagedSeize(UQ_MobileId const& mid)
{
  OTCLIB_MARKBLOCK(UQ,"Mobiles::pagedSeize()");

  OTC_Boolean pre1 = myMobiles.contains(mid);
  UQ_PRE("Mobiles::pagedSeize()",pre1);

  int call1 = myMobiles.item(mid)->pagedSeize();
  UQ_CALL("Mobiles::pagedSeize()",call1);

  UQ_INVARIANT("Mobiles::pagedSeize()");

  UQ_SUCCESS("Mobiles::pagedSeize()");
}

/* ------------------------------------------------------------------------- */
int UQ_Mobiles::callSeize(UQ_MobileId const& mid, UQ_PhoneId& pid)
{
  OTCLIB_MARKBLOCK(UQ,"Mobiles::callSeize()");

  OTC_Boolean pre1 = myMobiles.contains(mid);
  UQ_PRE("Mobiles::callSeize()",pre1);

  int call1 = myMobiles.item(mid)->callSeize(pid);
  UQ_CALL("Mobiles::callSeize()",call1);

  UQ_INVARIANT("Mobiles::callSeize()");

  UQ_SUCCESS("Mobiles::callSeize()");
}

/* ------------------------------------------------------------------------- */
int UQ_Mobiles::beTuned(UQ_MobileId const& mid, UQ_FreqId const& fid)
{
  OTCLIB_MARKBLOCK(UQ,"Mobiles::beTuned()");

  OTC_Boolean pre1 = myMobiles.contains(mid);
  UQ_PRE("Mobiles::beTuned()",pre1);

  int call1 = myMobiles.item(mid)->beTuned(fid);
  UQ_CALL("Mobiles::beTuned()",call1);

  UQ_INVARIANT("Mobiles::beTuned()");

  UQ_SUCCESS("Mobiles::beTuned()");
}

/* ------------------------------------------------------------------------- */
int UQ_Mobiles::answer(UQ_MobileId const& mid)
{
  OTCLIB_MARKBLOCK(UQ,"Mobiles::answer()");

  OTC_Boolean pre1 = myMobiles.contains(mid);
  UQ_PRE("Mobiles::answer()",pre1);

  int call1 = myMobiles.item(mid)->answer();
  UQ_CALL("Mobiles::answer()",call1);

  UQ_INVARIANT("Mobiles::answer()");

  UQ_SUCCESS("Mobiles::answer()");
}

/* ------------------------------------------------------------------------- */
int UQ_Mobiles::beHandedOver(
 UQ_MobileId const& mid,
 UQ_CellId const& cid,
 UQ_FreqId const& fid
)
{
  OTCLIB_MARKBLOCK(UQ,"Mobiles::beHandedOver()");

  OTC_Boolean pre1 = myMobiles.contains(mid);
  UQ_PRE("Mobiles::beHandedOver()",pre1);

  int call1 = myMobiles.item(mid)->beHandedOver(cid,fid);
  UQ_CALL("Mobiles::beHandedOver()",call1);

  UQ_INVARIANT("Mobiles::beHandedOver()");

  UQ_SUCCESS("Mobiles::beHandedOver()");
}

/* ------------------------------------------------------------------------- */
int UQ_Mobiles::beDisconnected(UQ_MobileId const& mid)
{
  OTCLIB_MARKBLOCK(UQ,"Mobiles::beDisconnected()");

  OTC_Boolean pre1 = myMobiles.contains(mid);
  UQ_PRE("Mobiles::beDisconnected()",pre1);

  int call1 = myMobiles.item(mid)->beDisconnected();
  UQ_CALL("Mobiles::beDisconnected()",call1);

  UQ_INVARIANT("Mobiles::beDisconnected()");

  UQ_SUCCESS("Mobiles::beDisconnected()");
}

/* ------------------------------------------------------------------------- */
OTC_Boolean UQ_Mobiles::invariant() const
{
  OTCLIB_MARKBLOCK(UQ,"Mobiles::invariant()");

  OTC_Boolean c1 = (myMobiles.population() == UQ_MobileId::population());

  OTC_Boolean c2 = OTCLIB_TRUE;
  OTC_Iterator<UQ_MobileId> iter1(myMobiles.keys());
  for (iter1.reset(); iter1.isValid(); iter1.next())
  {
    if (!UQ_MobileId::contains(iter1.item()))
    {
      c2 = OTCLIB_FALSE;
      break;
    }
  }

  return c1 && c2;
}

/* ------------------------------------------------------------------------- */
void UQ_Mobiles::dump(ostream& outs) const
{
  outs << "Mobiles::dump {" << endl;
  OTC_Iterator<UQ_Mobile*> iter(myMobiles.items());
  for (iter.reset(); iter.isValid(); iter.next())
    iter.item()->dump(outs);
  outs << "}" << endl;
}

/* ------------------------------------------------------------------------- */
