/*
// ============================================================================
//
// = AUTHOR(S)
//     Graham Dumpleton
//
// = COPYRIGHT
//     Copyright 1991 OTC LIMITED
//
// ============================================================================
*/

#include "phoneid.hh"
#include "prepost.hh"

#include <OTC/debug/tracer.hh>

#include <fstream.h>

/* ------------------------------------------------------------------------- */
OTC_Set<int> UQ_PhoneId::globIds;
OTC_Iterator<int> UQ_PhoneId::globIter = UQ_PhoneId::globIds.items();
UQ_PhoneId UQ_PhoneId::globId("phoneid.dat");

/* ------------------------------------------------------------------------- */
UQ_PhoneId::UQ_PhoneId(char const* theFile)
{
  OTCLIB_MARKBLOCK(UQ,"PhoneId::PhoneId()");

  ifstream ins(theFile);

  while (ins.good())
  {
    int id;
    ins >> id;
    if (!ins.fail())
    {
      OTCLIB_ASSERT(id != 0);
      if (id != 0)
	globIds.add(id);
    }
  }
}

/* ------------------------------------------------------------------------- */
UQ_PhoneId::~UQ_PhoneId()
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
UQ_PhoneId UQ_PhoneId::any()
{
  globIter.next();
  if (!globIter.isValid())
    globIter.reset();

  OTCLIB_ASSERT(globIter.isValid());

  return globIter.item();
}

/* ------------------------------------------------------------------------- */
ostream& operator<<(ostream& outs, UQ_PhoneId const& thePid)
{
  outs << int(thePid);
  return outs;
}

/* ------------------------------------------------------------------------- */
istream& operator>>(istream& ins, UQ_PhoneId& thePid)
{
  int aPid = 0;
  ins >> aPid;
  thePid = aPid;
  return ins;
}

/* ------------------------------------------------------------------------- */
