##
## $(C++COMPILER)_C++
## $(C++COMPILER)_CC
## $(C++COMPILER)_LD
##
## $(C++COMPILER)_CPPFLAGS
## $(C++COMPILER)_C++FLAGS
## $(C++COMPILER)_C++WARNINGFLAGS
## $(C++COMPILER)_CFLAGS
## $(C++COMPILER)_LDFLAGS
## $(C++COMPILER)_LDLIBS
##
## $(C++COMPILER)_CPPFLAGS_$(VARIANT)
## $(C++COMPILER)_C++FLAGS_$(VARIANT)
## $(C++COMPILER)_CFLAGS_$(VARIANT)
## $(C++COMPILER)_LDFLAGS_$(VARIANT)
## $(C++COMPILER)_LDLIBS_$(VARIANT)
##
## $(C++COMPILER)_PICVARIANTS
## $(C++COMPILER)_C++PICFLAGS
## $(C++COMPILER)_CPICFLAGS
## $(C++COMPILER)_LDPICFLAGS
##
## $(C++COMPILER)_LOPT
## $(C++COMPILER)_STDCPP
##
## Define these for each C++ compiler you have available and wish to be
## able to be used from makeit. Even if a C++ compiler is not capable of
## compiling the OSE C++ class libraries, you can define these variables
## for that compiler and you will be able to use that C++ compiler with
## makeit.
##
## The meanings of each of the variables are:
##
##   $(C++COMPILER)_C++		Full pathname of C++ compiler.
##
##   $(C++COMPILER)_CC		Full pathname of C compiler to use with
##				this C++ compiler.
##
##   $(C++COMPILER)_LD		Full pathname of linker to use with
##				this C++ compiler and C compiler. This
##				is only really important if your machine
##				supports shared libraries.
##
##   $(C++COMPILER)_CPPFLAGS	Any special preprocessor symbols which
##				should be used while compiling in any
##				variant.
##
##   $(C++COMPILER)_C++FLAGS	Any special C++ compiler options which
##				should be used while compiling in any
##				variant.
##
##   $(C++COMPILER)_C++WARNINGFLAGS
##				Any special C++ compiler options which
##				enable warnings about suspect C++.
##
##   $(C++COMPILER)_CFLAGS	Any special C compiler options which
##				should be used while compiling in any
##				variant.
##
##   $(C++COMPILER)_LDFLAGS	Any special linker options which
##				should be used while compiling in any
##				variant.
##
##   $(C++COMPILER)_LDLIBS	Any special libraries or object files
##				which should be linked while compiling
##				in any variant.
##
## The following variables should be defined if it is necessary to override
## the options for a variant, for a particular C/C++ compiler combination.
##
##   $(C++COMPILER)_CPPFLAGS_$(VARIANT)
##				Override for CPPFLAGS_$(VARIANT).
##
##   $(C++COMPILER)_C++FLAGS_$(VARIANT)
##				Override for C++FLAGS_$(VARIANT).
##
##   $(C++COMPILER)_CFLAGS_$(VARIANT)
##				Override for CFLAGS_$(VARIANT).
##
##   $(C++COMPILER)_LDFLAGS_$(VARIANT)
##				Override for LDFLAGS_$(VARIANT).
##
## The following variables should be defined if it is necessary to override
## how shared libraries are built for a specific C/C++ compiler combination.
##
##   $(C++COMPILER)_PICVARIANTS
##				Override for PICVARIANTS.
##
##   $(C++COMPILER)_C++PICFLAGS
##				Override for C++PICFLAGS.
##
##   $(C++COMPILER)_CPICFLAGS
##				Override for CPICFLAGS.
##
##   $(C++COMPILER)_LDPICFLAGS
##				Override for LDPICFLAGS.
##
## The following miscellaneous variables should also be defined if necessary.
##
##   $(C++COMPILER)_LOPT	Override for LOPT for a specific C/C++
##				compiler combination.
##
##   $(C++COMPILER)_STDCPP	Should be set to YES, if you have a C++
##				compiler which requires either the OSE
##				preprocessor in either template or non
##				template form, and where the guess made in
##				host/system.mk about whether you need an ANSI
##				style preprocessor is incorrect for a
##				particular C++ compiler. YES indicates that
##				an ANSI style preprocessor is required. Any
##				other values is taken to imply the negative.
##
## By default, Sun C++ version 3.0, does not inline code when the -g option
## is used. The result is that compiles take longer and object files are
## larger. If you want the compiler to always inline code, then uncomment
## the definition for the Sun compiler. In doing so you loose the ability
## to debug into inline code. If using Sun C++ with ObjectStore, you probably
## want to use -g0 at least for installing OSE. Otherwise, you are going
## to need a /tmp with 20MB available so that the ranlib of the library
## will work. Even with -g0, it can take 8-15MB.
##

ATT2.1_C++ = /usr/local/CC/ATT2.1/bin/CC
ATT2.1_CC = /bin/cc
ATT2.1_LD = /usr/bin/ld
ATT2.1_CPPFLAGS =
ATT2.1_C++FLAGS = -pipe +p
ATT2.1_C++WARNINGFLAGS = +w
ATT2.1_CFLAGS = -pipe

ATT3.0.1_C++ = /usr/local/CC/ATT3.0.1/bin/CC
ATT3.0.1_CC = /bin/cc
ATT3.0.1_LD = /usr/bin/ld
ATT3.0.1_CPPFLAGS =
ATT3.0.1_C++FLAGS = -pipe +p
ATT3.0.1_C++WARNINGFLAGS = +w
ATT3.0.1_CFLAGS = -pipe

CL2.1_C++ = /usr/local/CenterLine/2.1/bin/CC
CL2.1_CC = /bin/cc
CL2.1_LD = /usr/bin/ld
CL2.1_CPPFLAGS =
CL2.1_C++FLAGS = +p
CL2.1_C++WARNINGFLAGS = +w
CL2.1_CFLAGS =

CYG2.6.95Q3_C++ = /usr/local/cygnus/progressive-95q3/H-sparc-sun-sunos4.1.3/bin/g++
CYG2.6.95Q3_CC = /usr/local/cygnus/progressive-95q3/H-sparc-sun-sunos4.1.3/bin/gcc
CYG2.6.95Q3_LD = /usr/bin/ld
CYG2.6.95Q3_CPPFLAGS =
CYG2.6.95Q3_C++FLAGS = -pipe
CYG2.6.95Q3_C++WARNINGFLAGS = -Wall -Woverloaded-virtual
CYG2.6.95Q3_CFLAGS = -pipe
CYG2.6.95Q3_C++PICFLAGS = -fpic
CYG2.6.95Q3_CPICFLAGS = -fpic
CYG2.6.95Q3_PICVARIANTS =
CYG2.6.95Q3_LDFLAGS_prf = -static
CYG2.6.95Q3_LDLIBS = -lm

CYG2.7.95Q4_C++ = /usr/local/cygnus/progressive-95q4/H-sparc-sun-sunos4.1.4/bin/g++
CYG2.7.95Q4_CC = /usr/local/cygnus/progressive-95q4/H-sparc-sun-sunos4.1.4/bin/gcc
CYG2.7.95Q4_LD = /usr/bin/ld
CYG2.7.95Q4_CPPFLAGS =
CYG2.7.95Q4_C++FLAGS = -pipe
CYG2.7.95Q4_C++WARNINGFLAGS = -Wall -Woverloaded-virtual
CYG2.7.95Q4_CFLAGS = -pipe
CYG2.7.95Q4_C++PICFLAGS = -fpic
CYG2.7.95Q4_CPICFLAGS = -fpic
CYG2.7.95Q4_PICVARIANTS =
CYG2.7.95Q4_LDFLAGS_prf = -static
CYG2.7.95Q4_LDLIBS = -lm

GNU2.6.3_C++ = /usr/local/gnu/bin/g++
GNU2.6.3_CC = /usr/local/gnu/bin/gcc
GNU2.6.3_LD = /usr/bin/ld
GNU2.6.3_CPPFLAGS =
GNU2.6.3_C++FLAGS = -V 2.6.3 -pipe
GNU2.6.3_C++WARNINGFLAGS = -Wall
GNU2.6.3_CFLAGS = -V 2.6.3 -pipe
GNU2.6.3_C++PICFLAGS = -fpic
GNU2.6.3_CPICFLAGS = -fpic
# GNU2.6.3_PICVARIANTS =
GNU2.6.3_LDFLAGS_prf = -static
GNU2.6.3_LDLIBS = -lm

# LC3.2_C++ = /usr/local/energize/3.0/bin/lcc
# LC3.2_CC = /usr/local/energize/3.0/bin/lcc -Xa
# LC3.2_LD = /usr/bin/ld
# LC3.2_CPPFLAGS =
# LC3.2_C++FLAGS = -XF
# LC3.2_C++WARNINGFLAGS = -wa
# LC3.2_CFLAGS =

OS3.0_C++ = /pkg/ostore/bin/OSCC
OS3.0_CC = /bin/cc
OS3.0_LD = /usr/bin/ld
OS3.0_CPPFLAGS =
OS3.0_C++FLAGS = -pipe +p
OS3.0_C++WARNINGFLAGS = +w
OS3.0_CFLAGS = -pipe
OS3.0_C++FLAGS_dbg = -gx

SUN2.1_C++ = /usr/local/sparcworks/1.0/CC-2.1
SUN2.1_CC = /bin/cc
SUN2.1_LD = /usr/bin/ld
SUN2.1_CPPFLAGS =
SUN2.1_C++FLAGS = -pipe +p
SUN2.1_C++WARNINGFLAGS = +w
SUN2.1_CFLAGS = -pipe

SUN3.0.1_C++ = /usr/local/sparcworks/2.0.1/CC-3.0.1
SUN3.0.1_CC = /usr/local/sparcworks/2.0.1/acc-2.0.1
SUN3.0.1_LD = /usr/bin/ld
SUN3.0.1_CPPFLAGS =
SUN3.0.1_C++FLAGS = -pipe +p
SUN3.0.1_C++WARNINGFLAGS = +w
SUN3.0.1_CFLAGS =
ifeq "$(C++COMPILERENV)" "OSTORE"
SUN3.0.1_C++FLAGS_dbg = -g0
endif

SUN4.0.1_C++ = /usr/local/sparcworks/3.0.1/CC-4.0.1
SUN4.0.1_CC = /usr/local/sparcworks/3.0.1/acc-3.0.1
SUN4.0.1_LD = /usr/bin/ld
SUN4.0.1_CPPFLAGS =
SUN4.0.1_C++FLAGS = +p
SUN4.0.1_C++WARNINGFLAGS = +w
SUN4.0.1_CFLAGS =
ifeq "$(C++COMPILERENV)" "OSTORE"
SUN4.0.1_C++FLAGS_dbg = -g0
endif

##
## ATT3.0.1_C++LIBSEARCHPATCH
## SUN3.0.1_C++LIBSEARCHPATCH
##
## Define these to YES, if you have Sun C++ 3.0.1 or AT&T 3.0.1 and
## the CC program/script has been patched to search -l libraries for
## expanded templates. The Sun patches for this are listed in the
## PROBLEMS file. An unofficial patch for the AT&T compiler is included
## with OSE in the file "misc/ATT3.0.1.patch".
##

ATT3.0.1_C++LIBSEARCHPATCH = YES
SUN3.0.1_C++LIBSEARCHPATCH = YES

##
## ATT_C++CPPBROKEN
## OS_C++CPPBROKEN
##
## Define these to YES, if the C preprocessor which would normally be used
## by the C++ compiler is broken, has a small #include nesting limit, or
## doesn't understand C++ comments. When defined to YES, the preprocessor
## supplied with OSE will be used. These are required for SunOS 4.X,
## where the standard /lib/cpp has a #include nesting limit of only 10.
## You may alternatively install Sun patch 100151-01 to fix the SunOS C
## preprocessor.
##
## This currently only applies to AT&T 3.0.X (ATT) and ObjectStore (OS)
## C++ compilers.
##

ATT_C++CPPBROKEN = YES
OS_C++CPPBROKEN = YES

##
## PURIFYHOME
## PURELINKHOME
## QUANTIFYHOME
##
## If you have Purify, Quantify or Purelink, you should define these to
## where those products are installed. If the "purify", "quantify" and
## "purelink" commands always appear in the users PATH, these need not be
## defined.
##

PURIFYHOME = /usr/local/pure/purify-3.0a-sunos4
# PURELINKHOME = /usr/local/pure/purelink-1.1-sunos4
# QUANTIFYHOME = /usr/local/pure/quantify-1.0-sunos4

##
## SE_HOME
##
## If you have Sentinel, you should define this to where Sentinel is installed.
## If the "sentinel" command always appear in the users PATH, this need not be
## defined.
##

# SE_HOME = /usr/local/sentinel

##
## OS_ROOTDIR
## OS_VERSION
##
## If you have ObjectStore, OS_ROOTDIR should be set to the root directory of
## where ObjectStore is installed. If OS_ROOTDIR is always defined in the
## users environment, this need not be defined.
##
## The OS_VERSION variable should be set to the version of ObjectStore you
## are using.
##

ifeq "$(origin OS_ROOTDIR)" "undefined"
OS_ROOTDIR = /pkg/ostore
endif

OS_VERSION = 3.0

##
## SCHEMA_DB_DIR
##
## If you are installing a version of the OSE C++ class libraries for
## ObjectStore, and  you cannot create ObjectStore databases where you
## keep the OSE source code, define this to the name of a directory in
## which ObjectStore library schema databases can be built for OSE.
## Note that ObjectStore must be able to create databases in the area
## where you are installing OSE.
##

# SCHEMA_DB_DIR = ...

##
## VPP_RELEASE
##
## If you are installing a version of the OSE C++ class libraries for
## Versant, defined this to the name of the directory in which the release
## of Versant which should be used resides. If VERSANT_ROOT is always
## defined in the users environment, you need only adjust the version
## number and architecture in the default definition, rather than setting
## VPP_RELEASE explicitly.
##

# ifeq "$(origin VPP_RELEASE)" "undefined"
# VPP_RELEASE = $(VERSANT_ROOT)/2.1.4/sun4
# endif

##
## OO
##
## If you intend using the ODE C++ compiler front end, define this variable
## to the location of the "OO" program. It is expected that you have
## configured the version of "OO" for the particular C++ compiler you are
## going to use. If you have multiple versions of "OO", you should check
## the C++COMPILER variable and make a choice between them.
##

# ifeq "$(C++COMPILER)" "SUN2.1"
# OO = $(ODEDIR)/o++2.0/bin/OO
# endif

##
## X11_INCDIR
## X11_LIBDIR
##
## Define these to the location of X11 include files and libraries
## respectively.
##

X11_INCDIR = /usr/local/X11
X11_LIBDIR = /usr/lib/X11

##
## TCL_INCDIR
## TCL_LIBDIR
##
## Defined these to the location of TCL/TK include files and libraries
## respectively.
##

TCL_VERSION = 7.4
TK_VERSION = 4.0

TCL_INCDIR = /usr/local/tcl/7.4/include
TCL_LIBDIR = /usr/local/tcl/7.4/lib
