##
## CPPFLAGS_$(VARIANT)
## C++FLAGS_$(VARIANT)
## CFLAGS_$(VARIANT)
## LDFLAGS_$(VARIANT)
##
## Define these for each variant you have listed in the VARIANTS variable.
## The meanings of each of the variables are:
##
##   CPPFLAGS_$(VARIANT)	Preprocessor options for that variant.
##
##   C++FLAGS_$(VARIANT)	C++ compiler options for that variant.
##
##   CFLAGS_$(VARIANT)		C compiler options for that variant.
##
##   LDFLAGS_$(VARIANT)		Linker options for that variant.
##
## Note that these are defaults only. You can override these for a specific
## C/C++ compiler combination later on.
##
## You might like to add "-DOTCLIB_TRACE" to the CPPFLAGS for all but the
## "opt" variant. This will ensure that trace code is always compiled into
## your code, except in the case of a release version compiled in the "opt"
## variant.
##

CPPFLAGS_dbg =
C++FLAGS_dbg = -g
CFLAGS_dbg = -g

CPPFLAGS_opt = -DNDEBUG
C++FLAGS_opt = -O
CFLAGS_opt = -O

CPPFLAGS_prf =
C++FLAGS_prf = -pg
CFLAGS_prf = -pg
LDFLAGS_prf =

CPPFLAGS_std =
C++FLAGS_std =
CFLAGS_std =

##
## C++PICFLAGS
## CPICFLAGS
## LDPICFLAGS
##
## Define these variables corresponding to how shared libraries are created.
## The meanings of each of the variables are:
##
##   C++PICFLAGS		The flags which should be supplied to the
##				C++ compiler to produce position indepedent
##				object files.
##
##   CPICFLAGS			The flags which should be supplied to the
##				C compiler to produce position indepedent
##				object files.
##
##   LDPICFLAGS			The flags which should be supplied to the
##				linker when producing a shared library.
##
## Note that these are defaults only. You can override these for a specific
## C/C++ compiler combination later on.
##

# C++PICFLAGS = -pic
# CPICFLAGS = -pic
# LDPICFLAGS = -assert pure-text

##
## PICINSTALL
##
## Define this variable corresponding to how a shared library should be
## installed. This must be defined if you have set PICVARIANTS.
##

# define PICINSTALL
# $(INSTALL.BIN) $(MK)/lib.so $(LIBDIR)/lib$(LIBRARY).so.$(LIBVERSION)
# $(RM) $(LIBDIR)/lib$(LIBRARY).so
# ln -s lib$(LIBRARY).so.$(LIBVERSION) $(LIBDIR)/lib$(LIBRARY).so
# if test -f $(MK)/lib.sa.a; \
# then \
#   $(INSTALL.LIB) $(MK)/lib.sa.a $(LIBDIR)/lib$(LIBRARY).sa.$(LIBVERSION); \
#   $(RANLIB) $(LIBDIR)/lib$(LIBRARY).sa.$(LIBVERSION); \
# fi
# endef

##
## LOPT
##
## Define this variable to the flag which is used to tell the linker which
## directories to search for libraries. Generally this is "-L" but is not
## on all platforms or with all compilers. For example on a Pyramid this
## should be "-Wl,-L".
##
## Note that this is the default only. You can override this for a specific
## C/C++ compiler combination later on.
##

LOPT = -L

##
## RANLIB
##

RANLIB = : ranlib

##
## INSTALL
##

INSTALL = cp
