#ifndef OTC_ANSI_TEMPLATE_HH
#define OTC_ANSI_TEMPLATE_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTC
//
// = FILENAME
//     ansi/template.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1991 1992 OTC LIMITED
//
// ============================================================================
*/

/* ------------------------------------------------------------------------- */
// Following is required by the COOL C-preprocessor for implementing
// templates.
//
// For more general information about templates you should see p342-351
// of the ARM.

#ifdef __OSE_TEMPLATES__
#pragma defmacro template "template" delimiter=}
#pragma defmacro COOL_DECLARE "declare" delimiter=> recursive lines
#pragma defmacro COOL_IMPLEMENT "implement" delimiter=> recursive lines
#pragma defmacro OSE_DECLARE "declare_once" delimiter=> recursive lines
#pragma defmacro OSE_IMPLEMENT "implement_once" delimiter=> recursive lines
#pragma defmacro OSE_TEMPLATE "ose_template" delimiter=> recursive lines
#pragma defmacro OSE_PRECOMPILE "ose_precompile" delimiter=> recursive lines
#pragma defmacro OSE_MARK_OVERRIDE "ose_markover" delimiter=> recursive lines
#pragma defmacro OSE_MARK_TEMPLATE "ose_markover" delimiter=> recursive lines
#pragma defmacro OSE_MARK_IMPLEMENT "ose_markiover" delimiter=> recursive lines
#pragma defmacro OSE_MARK_COMPILED "ose_markcomp" delimiter=> recursive lines
#endif

/* ------------------------------------------------------------------------- */
// Makeit defines just EXPAND_TEMPLATES now. Provide definition below
// so old symbol of OSE_IMPLEMENT_TEMPLATES is still okay. This assumes
// that all template files include <OTC/OTC.h> which should be the case
// as they have to see the above definitions in order to work with the
// template preprocessor.

#ifdef EXPAND_TEMPLATES
#define OSE_IMPLEMENT_TEMPLATES 1
#endif

/* ------------------------------------------------------------------------- */

#endif /* OTC_ANSI_TEMPLATE_HH */
