#ifndef OTC_COLLCTN_BNDQUEUE_C
#define OTC_COLLCTN_BNDQUEUE_C
/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     collctn/bndqueue.c
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1992 1993 OTC LIMITED
//     Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

/* ------------------------------------------------------------------------- */
template<class T>
OTC_BoundedQueue<T>::~OTC_BoundedQueue()
{
  if (myItems && myDestroy)
  {
    delete [] myItems;
  }
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_BoundedQueue<T>::OTC_BoundedQueue(u_int theCapacity, T* theMem)
  : myCapacity(theCapacity), myCount(0), myGet(0), myPut(0),
    myItems(theMem), myDestroy(OTCLIB_FALSE)
{
  if (theMem == 0 && myCapacity > 0)
  {
#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
    OTC_Locality theLocality = OTC_Locality::of(this);
#endif

#if defined(ENV_OSTORE_DML)
    myItems = new ((os_segment*)theLocality) T[myCapacity];
#else
#if defined(ENV_OSTORE)
    myItems = new (theLocality,OTC_TypeSpec<T>::typespec(),myCapacity)
     T[myCapacity];
#else
    myItems = new T[myCapacity];
#endif
#endif
    OTCLIB_ASSERT(myItems != 0);
    myDestroy = OTCLIB_TRUE;
  }
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_BoundedQueue<T>::OTC_BoundedQueue(OTC_BoundedQueue<T> const& theQueue)
  : myCapacity(theQueue.myCapacity), myCount(0),
    myGet(0), myPut(0), myItems(0), myDestroy(OTCLIB_TRUE)
{
#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
#endif

#if defined(ENV_OSTORE_DML)
  myItems = new ((os_segment*)theLocality) T[myCapacity];
#else
#if defined(ENV_OSTORE)
  myItems = new (theLocality,OTC_TypeSpec<T>::typespec(),myCapacity)
   T[myCapacity];
#else
  myItems = new T[myCapacity];
#endif
#endif
  OTCLIB_ASSERT(myItems != 0);

  for (u_int i=0; i<theQueue.count(); i++)
    add(theQueue.peek(i));
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_BoundedQueue<T>& OTC_BoundedQueue<T>::operator=(
 OTC_BoundedQueue<T> const& theQueue
)
{
  if (&theQueue == this)
    return *this;

  if (myDestroy)
    delete [] myItems;

  myCapacity = theQueue.myCapacity;
  myDestroy = OTCLIB_TRUE;
  myCount = 0;
  myGet = 0;
  myPut = 0;

#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
#endif

#if defined(ENV_OSTORE_DML)
  myItems = new ((os_segment*)theLocality) T[myCapacity];
#else
#if defined(ENV_OSTORE)
  myItems = new (theLocality,OTC_TypeSpec<T>::typespec(),myCapacity)
   T[myCapacity];
#else
  myItems = new T[myCapacity];
#endif
#endif
  OTCLIB_ASSERT(myItems != 0);

  for (u_int i=0; i<theQueue.count(); i++)
    add(theQueue.peek(i));

  return *this;
}

/* ------------------------------------------------------------------------- */
template<class T>
void OTC_BoundedQueue<T>::add(T const& theItem)
{
  OTCLIB_ENSURE((!isFull()),
   "OTC_BoundedQueue::add() - Queue full");
  if (myPut >= myCapacity)
    myPut = 0;
  myItems[myPut++] = theItem;
  if (myPut >= myCapacity)
    myPut = 0;
  myCount++;
}

/* ------------------------------------------------------------------------- */
template<class T>
T OTC_BoundedQueue<T>::remove()
{
  OTCLIB_ENSURE((!isEmpty()),
   "OTC_BoundedQueue::remove() - Queue empty");
  myCount--;
  u_int theIndex = myGet;
  myGet++;
  if (myGet >= myCapacity)
    myGet = 0;
  return myItems[theIndex];
}

/* ------------------------------------------------------------------------- */
template<class T>
void OTC_BoundedQueue<T>::discard(u_int theCount)
{
  OTCLIB_ENSURE((theCount <= myCount),
   "OTC_BoundedQueue::discard() - Insufficient items");
  if (myCapacity != 0)
    myGet = (myGet + theCount) % myCapacity;
  myCount -= theCount;
}

/* ------------------------------------------------------------------------- */
template<class T>
T& OTC_BoundedQueue<T>::_head() const
{
  OTCLIB_ENSURE((!isEmpty()),
   "OTC_BoundedQueue::_head() - Queue empty");
  return myItems[myGet];
}

/* ------------------------------------------------------------------------- */
template<class T>
T& OTC_BoundedQueue<T>::_peek(u_int theIndex) const
{
  OTCLIB_ENSURE((theIndex < myCount),
   "OTC_BoundedQueue::_peek() - Index out of range");
  u_int anIndex = myGet+theIndex;
  if (anIndex >= myCapacity)
    anIndex -= myCapacity;

  return myItems[anIndex];
}

/* ------------------------------------------------------------------------- */

#endif /* OTC_COLLCTN_BNDQUEUE_C */
