#ifndef OTC_COLLCTN_BNDSTACK_C
#define OTC_COLLCTN_BNDSTACK_C
/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     collctn/bndstack.c
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1992 1993 OTC LIMITED
//     Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

/* ------------------------------------------------------------------------- */
template<class T>
OTC_BoundedStack<T>::~OTC_BoundedStack()
{
  if (myItems && myDestroy)
  {
    delete [] myItems;
  }
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_BoundedStack<T>::OTC_BoundedStack(u_int theCapacity, T* theMem)
  : myCapacity(theCapacity), myPut(0), myItems(theMem), myDestroy(OTCLIB_FALSE)
{
  if (theMem == 0 && myCapacity > 0)
  {
#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
    OTC_Locality theLocality = OTC_Locality::of(this);
#endif

#if defined(ENV_OSTORE_DML)
    myItems = new ((os_segment*)theLocality) T[myCapacity];
#else
#if defined(ENV_OSTORE)
    myItems = new (theLocality,OTC_TypeSpec<T>::typespec(),myCapacity)
     T[myCapacity];
#else
    myItems = new T[myCapacity];
#endif
#endif
    OTCLIB_ASSERT(myItems != 0);
    myDestroy = OTCLIB_TRUE;
  }
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_BoundedStack<T>::OTC_BoundedStack(OTC_BoundedStack<T> const& theStack)
  : myCapacity(theStack.myCapacity), myPut(0), myItems(0),
    myDestroy(OTCLIB_TRUE)
{
#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
#endif

#if defined(ENV_OSTORE_DML)
  myItems = new ((os_segment*)theLocality) T[myCapacity];
#else
#if defined(ENV_OSTORE)
  myItems = new (theLocality,OTC_TypeSpec<T>::typespec(),myCapacity)
   T[myCapacity];
#else
  myItems = new T[myCapacity];
#endif
#endif
  OTCLIB_ASSERT(myItems != 0);

  for (int i=theStack.count(); i>0; i--)
    push(theStack.peek(i-1));
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_BoundedStack<T>& OTC_BoundedStack<T>::operator=(
 OTC_BoundedStack<T> const& theStack
)
{
  if (&theStack == this)
    return *this;

  if (myDestroy)
    delete [] myItems;

  myCapacity = theStack.myCapacity;
  myPut = 0;
  myDestroy = OTCLIB_TRUE;

#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
#endif

#if defined(ENV_OSTORE_DML)
  myItems = new ((os_segment*)theLocality) T[myCapacity];
#else
#if defined(ENV_OSTORE)
  myItems = new (theLocality,OTC_TypeSpec<T>::typespec(),myCapacity)
   T[myCapacity];
#else
  myItems = new T[myCapacity];
#endif
#endif
  OTCLIB_ASSERT(myItems != 0);

  for (int i=theStack.count(); i>0; i--)
    push(theStack.peek(i-1));

  return *this;
}

/* ------------------------------------------------------------------------- */

#endif /* OTC_COLLCTN_BNDSTACK_C */
