#ifndef OTC_COLLCTN_BUCKCURS_C
#define OTC_COLLCTN_BUCKCURS_C
/*
// ============================================================================
//
// = LIBRARY
//     OTC
//
// = FILENAME
//     collctn/buckcurs.c
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1991 1992 1993 OTC LIMITED
//     Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/collctn/linklist.hh>
#include <OTC/collctn/bucket.hh>

/* ------------------------------------------------------------------------- */
#ifdef __OSE_TEMPLATES__
template<class T> OTC_BucketCursor
{
  OSE_DECLARE OTC_Bucket<T>;
  OSE_IMPLEMENT OTC_Cursor<T>;
  OSE_IMPLEMENT OTC_Bucket<T>;
};
#endif

/* ------------------------------------------------------------------------- */
template<class T>
OTC_BucketCursor<T>::~OTC_BucketCursor()
{
  if (myProtection == OTCLIB_SAFE)
    myList->unReference();
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_BucketCursor<T>::OTC_BucketCursor(
 OTC_LinkList* aList,
 OTC_Direction theDirection,
 OTC_Protection theProtection
)
 : myList(aList),
   myIter(myList->items(theProtection)),
   myDirection(theDirection),
   myProtection(theProtection)
{
  if (myProtection == OTCLIB_SAFE)
    myList->reference();

  reset();
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_BucketCursor<T>::OTC_BucketCursor(
 OTC_LinkList* aList,
 OTC_Linkable* theStart,
 OTC_Linkable* theEnd,
 OTC_Direction theDirection,
 OTC_Protection theProtection
)
 : myList(aList),
   myIter(theStart,theEnd,theProtection),
   myDirection(theDirection),
   myProtection(theProtection)
{
  if (myProtection == OTCLIB_SAFE)
    myList->reference();

  reset();
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_BucketCursor<T>::OTC_BucketCursor(OTC_BucketCursor<T> const& aIter)
 : myList(aIter.myList),
   myIter(aIter.myIter),
   myDirection(aIter.myDirection),
   myProtection(aIter.myProtection)
{
  if (myProtection == OTCLIB_SAFE)
    myList->reference();
}

/* ------------------------------------------------------------------------- */
template<class T>
void OTC_BucketCursor<T>::reset()
{
  if (direction() == OTCLIB_FORWARD)
    myIter.resetFirst();
  else
    myIter.resetLast();
}

/* ------------------------------------------------------------------------- */
template<class T>
T& OTC_BucketCursor<T>::item()
{
  OTCLIB_ENSURE((myIter.isLink()),
   "OTC_BucketCursor::item() - No item under cursor");

  return ((OTC_Bucket<T>*)myIter.link())->item();
}

/* ------------------------------------------------------------------------- */
template<class T>
void OTC_BucketCursor<T>::next()
{
  if (direction() == OTCLIB_FORWARD)
    myIter.next();
  else
    myIter.prev();
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_Boolean OTC_BucketCursor<T>::isValid() const
{
  return myIter.isLink();
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_Cursor<T>* OTC_BucketCursor<T>::clone()
{
#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
#endif

  OTC_BucketCursor<T>* theIter;
#if defined(ENV_OSTORE_DML)
  theIter = new ((os_segment*)theLocality) OTC_BucketCursor<T>(*this);
#else
#if defined(ENV_OSTORE)
  theIter = new (theLocality,OTC_BucketCursor<T>::get_os_typespec())
   OTC_BucketCursor<T>(*this);
#else
  theIter = new OTC_BucketCursor<T>(*this);
#endif
#endif
  OTCLIB_ASSERT(theIter != 0);
  return theIter;
}

/* ------------------------------------------------------------------------- */
template<class T>
void OTC_BucketCursor<T>::reverse()
{
  if (direction() == OTCLIB_FORWARD)
    myDirection = OTCLIB_BACKWARD;
  else
    myDirection = OTCLIB_FORWARD;
}

/* ------------------------------------------------------------------------- */

#endif /* OTC_COLLCTN_BUCKCURS_C */
