#ifndef OTC_COLLCTN_BUCKCURS_HH
#define OTC_COLLCTN_BUCKCURS_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTC
//
// = FILENAME
//     collctn/buckcurs.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1991 1992 1993 OTC LIMITED
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/collctn/cursor.hh>
#include <OTC/collctn/dirction.hh>
#include <OTC/collctn/linkiter.hh>

#ifdef __GNUG__
#if defined(EXPAND_TEMPLATES)
#pragma implementation "OTC/collctn/buckcurs.hh"
#endif
#if (__GNUC__ >= 3 || __GNUC_MINOR__ >= 6) || defined(CXX_CYGNUS)
#pragma interface "OTC/collctn/buckcurs.hh"
#else
#pragma interface
#endif
#endif

/* ------------------------------------------------------------------------- */

#ifdef __OSE_TEMPLATES__
template<class T> OTC_BucketCursor
{
  OSE_DECLARE OTC_Cursor<T>;
};
#endif

class OTC_LinkList;

template<class T>
class OTC_BucketCursor : public OTC_Cursor<T>
    // = TITLE
    //     Iterator over items held in <OTC_Bucket>.
    //
    // = CLASS TYPE
    //     Concrete
    //
    // = DESCRIPTION
    //     Derived version of <OTC_Cursor>, which iterates over the items
    //     in an instance of <OTC_LinkList>, where the derived type of
    //     link is <OTC_Bucket>.
    //
    //     This class should no longer be used. Instead the <OTC_ItemCursor>
    //     class should be used. The <OTC_BucketCursor> class will be
    //     removed in OSE 4.0.
{
  public:

			~OTC_BucketCursor();

    // = INITIALISATION

			OTC_BucketCursor(
			  OTC_LinkList* aList,
			  OTC_Direction theDirection=OTCLIB_FORWARD,
			  OTC_Protection theProtection=OTCLIB_SAFE
			);
				// <aList> is the list being iterated over.
				// <theDirection> indicates which way
				// traversal is to occur. If <theDirection>
				// is <OTCLIB_FORWARD>, traversal will be
				// from the start of <aList> to the end. If
				// it is <OTCLIB_BACKWARD>, it will be in the
				// opposite direction. <theProtection>
				// determines whether reference counting is
				// performed on the links in the list.
				// Reference counting ensures the integrity of
				// the iterator when removals and additions
				// are perfomed. The values for <theProtection>
				// are <OTCLIB_SAFE> and <OTCLIB_UNSAFE>.
				// The default argument is <OTCLIB_UNSAFE>.

			OTC_BucketCursor(
			  OTC_LinkList* aList,
			  OTC_Linkable* theStart,
			  OTC_Linkable* theEnd,
			  OTC_Direction theDirection=OTCLIB_FORWARD,
			  OTC_Protection theProtection=OTCLIB_SAFE
			);
				// <aList> is the list being iterated over.
				// <theStart> and <theEnd> are the anchor
				// points within the list which define the
				// bounds of the iterator. If <theDirection>
				// is <OTCLIB_FORWARD>, traversal will be
				// from the <theStart> to <theEnd>. If it
				// is <OTCLIB_BACKWARD>, it will be in
				// the opposite direction. Note that this
				// class relies on <theStart> preceeding
				// <theEnd> in the list. <theProtection>
				// determines whether reference counting is
				// performed on the links in the list.
				// Reference counting ensures the integrity of
				// the iterator when removals and additions
				// are perfomed. The values for <theProtection>
				// are <OTCLIB_SAFE> and <OTCLIB_UNSAFE>.
				// The default argument is <OTCLIB_UNSAFE>.

			OTC_BucketCursor(
			 OTC_BucketCursor<T> const& aIter
			);
				// Create an iterator at the same location as
				// <aIter>.

    // = MOVEMENT
    //     Following operations allow movement of the iterator over the
    //     list.

    void		reset();
				// Resets the iterator to the first item.

    void		next();
				// Moves the iterator to the next item.

    // = RETRIEVAL

    T&			item();
				// Returns the item under the current
				// location of the iterator. If no such item
				// exists, an exception is raised. Note that
				// this returns the item even if the bucket
				// has been marked as dead.

    OTC_Boolean		isValid() const;
				// Returns <OTCLIB_TRUE> while there is a
				// link under the current location of the
				// iterator and not an anchor point. In other
				// words if the iterator is located over a
				// link which has been marked as dead, then
				// <OTCLIB_TRUE> will still be returned.

    // = CLONING

    OTC_Cursor<T>*	clone();
				// Creates a new iterator at the same location
				// as this one but which operates
				// independently.

    // = DIRECTION

    OTC_Direction	direction() const
				{ return myDirection; }
				// Returns the direction in which the iterator
				// is moving.

    void		reverse();
				// Change the direction the iterator is
				// moving.

  public:

#if defined(ENV_OSTORE)
    static os_typespec*	get_os_typespec();
#endif

  private:

    OTC_LinkList*	myList;
				// The list being iterated over.

    OTC_LinkIterator	myIter;
				// The iterator doing the real work.

    OTC_Direction	myDirection;
				// The direction through this list which
				// the iterator will move.

    OTC_Protection	myProtection;
				// Has value of <OTCLIB_SAFE> if internal
				// reference counting should be performed.
};

/* ------------------------------------------------------------------------- */

#if defined(EXPAND_TEMPLATES)
#include <OTC/collctn/buckcurs.c>
#endif

/* ------------------------------------------------------------------------- */

#endif /* OTC_COLLCTN_BUCKCURS_HH */
