#ifndef OTC_COLLCTN_COLLCTN_HH
#define OTC_COLLCTN_COLLCTN_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTC
//
// = FILENAME
//     collctn/collctn.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1991 1992 1993 OTC LIMITED
//     Copyright 1994 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/collctn/iterator.hh>
#include <OTC/collctn/prtction.hh>

#ifdef __GNUG__
#if defined(EXPAND_TEMPLATES)
#pragma implementation "OTC/collctn/collctn.hh"
#endif
#if (__GNUC__ >= 3 || __GNUC_MINOR__ >= 6) || defined(CXX_CYGNUS)
#pragma interface "OTC/collctn/collctn.hh"
#else
#pragma interface
#endif
#endif

/* ------------------------------------------------------------------------- */

#ifdef __OSE_TEMPLATES__
template<class T> OTC_Collection
{
  OSE_DECLARE OTC_Iterator<T>;
};
#endif

template<class T>
class OTC_Collection
    // = TITLE
    //     Abstract base class for a collection of objects.
    //
    // = CLASS TYPE
    //     Concrete
    //
    // = DESCRIPTION
    //     This class is the ultimate base class of any collection. It
    //     embodies the abstractions that all collections must provide.
    //
    //     These are:
    //
    // = BEGIN<INDENT>
    //     - The ability to return a class that will allow iteration
    //       over all items contained in the collection.
    //
    //     - The ability to determine the number of items in the collection.
    //
    //     - The ability to empty the collection.
    // = END<INDENT>
    //
    // = NOTES
    //     <removeAll()>, <population()> and <items()> must be redefined in a
    //     derived class. <isEmpty()> should also be redefined in a derived
    //     class if possible, as the default for <isEmpty()> is to compare
    //     the result of <population()> against <0>. This is potentially
    //     inefficient, depending on the implementation of a particular
    //     collection.
    //
    //     It is possible to create an instance of the <OTC_Collection>
    //     class. If you do, it will behave like an empty collection,
    //     always returning a population of <0> and a null iterator.
    //
    // = EXAMPLE
    //     An example of how a collection class could be used.
    //
    // = BEGIN<CODE>
    //     void sum(OTC_Collection<int>& theColl)
    //     {
    //       int theSum = 0;
    //       if (!theColl.isEmpty())
    //       {
    //         OTC_Iterator<int> aIter = 0;
    //         anIter = theColl.items();
    //         for (aIter.reset(); aIter.isValid(); aIter.next())
    //           theSum += aIter.item();
    //         theColl.removeAll();
    //       }
    //       cout << theSum << endl;
    //     }
    // = END<CODE>
    //
    //     If a function only requires the ability to iterate over a
    //     collection as above, the function should be written to accept the
    //     collection base class. This would allow any type of collection to
    //     be passed to the function and not just the particular one that
    //     was being used at that time.
    //     
    // = SEE ALSO
    //     <OTC_Iterator>
{
  public:

    virtual		~OTC_Collection();

    // = CONSTRUCTION

			OTC_Collection();
				// Creates an empty collection.

    // = DESTRUCTION

    virtual void	removeAll();
				// Removes all items in the collection.

    // = ENQUIRY

    virtual OTC_Boolean	isEmpty() const;
				// Returns <OTCLIB_TRUE> if the collection is
				// empty.

    virtual u_int	population() const;
				// Returns the number of items in the
				// collection.

    // = ITERATION

    virtual OTC_Iterator<T>	items(
				 OTC_Protection theProtection=OTCLIB_SAFE
				) const;
				// Returns a class which will allow iteration
				// over all items contained in the collection.

  private:

			OTC_Collection(OTC_Collection<T> const &)
				{ terminate(); }
				// Do not define an implementation for this.

    OTC_Collection<T>&	operator=(OTC_Collection<T> const &)
				{ terminate(); return *this; }
				// Do not define an implementation for this.
};

/* ------------------------------------------------------------------------- */

#if defined(EXPAND_TEMPLATES)
#include <OTC/collctn/collctn.c>
#endif

/* ------------------------------------------------------------------------- */

#endif /* OTC_COLLCTN_COLLCTN_HH */
