#ifndef OTC_COLLCTN_CURSOR_HH
#define OTC_COLLCTN_CURSOR_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTC
//
// = FILENAME
//     collctn/cursor.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1991 1992 1993 OTC LIMITED
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/refcnt/resource.hh>

#if !defined(ENV_NOAPPLICATORS)
#include <OTC/collctn/visitor.hh>
#include <OTC/collctn/worker.hh>
#endif

#ifdef __GNUG__
#if defined(EXPAND_TEMPLATES)
#pragma implementation "OTC/collctn/cursor.hh"
#endif
#if (__GNUC__ >= 3 || __GNUC_MINOR__ >= 6) || defined(CXX_CYGNUS)
#pragma interface "OTC/collctn/cursor.hh"
#else
#pragma interface
#endif
#endif

/* ------------------------------------------------------------------------- */

#ifdef __OSE_TEMPLATES__
template<class T> OTC_Cursor
{
#if !defined(ENV_NOAPPLICATORS)
  OSE_DECLARE OTC_Visitor<T>;
  OSE_DECLARE OTC_Worker<T>;
#endif
};
#endif

template<class T>
class OTC_Cursor : public OTC_Resource
    // = TITLE
    //	   Abstract base class for implementations of iterators.
    //
    // = CLASS TYPE
    //	   Abstract
    //
    // = DESCRIPTION
    //	   Abstract base class, for classes which implement iteration
    //	   over specific types of collections.
{
  private:

    virtual void	bogus();
				// Bogus virtual functions to get Sun
				// C++ 4.0 to work.

  public:

    			~OTC_Cursor();

			OTC_Cursor();

    // = MOVEMENT
    //	   Following operations allow movement of the iterator over the
    //	   collection.

    virtual void	reset() = 0;
				// Resets the iterator to the start.

    virtual void	next() = 0;
				// Moves the iterator to the next item.

    // = RETRIEVAL
    //	   These operations provide access to the current item in the
    //	   collection.
    //
    //	   Although dependent on the derived iterator and how the collection
    //	   being iterated over is implemented, an exception will generally
    //	   result if an attempt is made to access an item, when the iterator
    //	   is not currently located at one.

    virtual T&		item() = 0;
				// Returns the item under the current
				// location of the iterator.

    virtual OTC_Boolean isValid() const = 0;
				// Should return <OTCLIB_TRUE> while there is
				// a valid data item under the current
				// location of the iterator.

    // = CLONING

    virtual OTC_Cursor<T>*	clone() = 0;
				// Produces a new iterator at the same
				// location as this one, but which functions
				// independently.

    // = APPLICATORS

#if !defined(ENV_NOAPPLICATORS)

    static void		apply(
			 OTC_Cursor<T>* theCursor,
			 OTC_Visitor<T>& theApplicator
			);
				// Applies <theApplicator> to each item
				// accessible by <theCursor>.

    static void		apply(
			 OTC_Cursor<T>* theCursor,
			 OTC_Worker<T>& theApplicator
			);
				// Applies <theApplicator> to each item
				// accessible by <theCursor>.

#endif

    // = REFERENCE COUNTING

    static void		assign(
			 OTC_Cursor<T>*& theLeft,
			 OTC_Cursor<T>* theRight
			);
				// References <theRight> and then updates
				// <theLeft> with <theRight>. Handles
				// <theRight> being null.

    static void		replace(
			 OTC_Cursor<T>*& theLeft,
			 OTC_Cursor<T>* theRight
			);
				// References <theRight>, unreferences
				// <theLeft> and then updates the variable
				// <theLeft> with <theRight>. Handles
				// null pointers and pointers which are
				// equivalent.
};

/* ------------------------------------------------------------------------- */

#if defined(EXPAND_TEMPLATES)
#include <OTC/collctn/cursor.c>
#endif

#if (__GNUG__ == 2 && __GNUC_MINOR__ == 5)
template<class T>
inline OTC_Cursor<T>::~OTC_Cursor()
{
  // Nothing to do.
}
#endif

/* ------------------------------------------------------------------------- */

#endif /* OTC_COLLCTN_CURSOR_HH */
