#ifndef OTC_COLLCTN_DEQUE_C
#define OTC_COLLCTN_DEQUE_C
/*
// ============================================================================
//
// = LIBRARY
//     OTC
//
// = FILENAME
//     collctn/deque.c
// 
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1991 1992 1993 OTC LIMITED
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/collctn/icursor.hh>

/* ------------------------------------------------------------------------- */
#ifdef __OSE_TEMPLATES__
template<class T> OTC_Deque
{
  OSE_DECLARE OTC_ItemCursor< T,OTC_Bucket<T> >;
  OSE_IMPLEMENT OTC_Iterator<T>;
  OSE_IMPLEMENT OTC_Modifier<T>;
  OSE_IMPLEMENT OTC_Bucket<T>;
  OSE_IMPLEMENT OTC_ItemCursor< T,OTC_Bucket<T> >;
};
#endif

/* ------------------------------------------------------------------------- */
template<class T>
OTC_Deque<T>::OTC_Deque(OTC_Deque<T> const& theDeque)
{
  OTC_Iterator<T> iter = 0;
  iter = theDeque.items(OTCLIB_FORWARD,OTCLIB_UNSAFE);
  for (iter.reset(); iter.isValid(); iter.next())
    addLast(iter.item());
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_Deque<T>::OTC_Deque(OTC_Deque<T>& theDeque, OTC_ShallowCopy)
  : myList(theDeque.myList)
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_Deque<T>& OTC_Deque<T>::operator=(OTC_Deque<T> const& theDeque)
{
  if (&theDeque != this)
  {
    removeAll();
    OTC_Iterator<T> iter = 0;
    iter = theDeque.items(OTCLIB_FORWARD,OTCLIB_UNSAFE);
    for (iter.reset(); iter.isValid(); iter.next())
      addLast(iter.item());
  }

  return *this;
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_Cursor<T>* OTC_Deque<T>::_items(
 OTC_Direction theDirection,
 OTC_Protection theProtection
) const
{
#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
  if (!theLocality.isTransientSegment())
  {
    os_transaction* theTXN = os_transaction::get_current();
    if (theTXN != 0 && theTXN->get_type() == os_transaction::read_only)
      theProtection = OTCLIB_UNSAFE;

    if (theProtection == OTCLIB_UNSAFE)
      theLocality = os_segment::get_transient_segment();
  }
#endif

  OTC_Cursor<T>* theIter;
#if defined(ENV_OSTORE_DML)
  theIter = new ((os_segment*)theLocality) OTC_ItemCursor< T,OTC_Bucket<T> >(
   myList.list(),theDirection,theProtection);
#else
#if defined(ENV_OSTORE)
  theIter = new (theLocality,
   OTC_ItemCursor< T,OTC_Bucket<T> >::get_os_typespec())
   OTC_ItemCursor< T,OTC_Bucket<T> >(myList.list(),theDirection,
   theProtection);
#else
  theIter = new OTC_ItemCursor< T,OTC_Bucket<T> >(myList.list(),theDirection,
   theProtection);
#endif
#endif
  OTCLIB_ASSERT(theIter != 0);
  return theIter;
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_Link* OTC_Deque<T>::_link(T const& theItem)
{
#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
#endif

  OTC_Bucket<T>* theBucket;
#if defined(ENV_OSTORE_DML)
  theBucket = new ((os_segment*)theLocality) OTC_Bucket<T>(theItem);
#else
#if defined(ENV_OSTORE)
  theBucket = new (theLocality,OTC_Bucket<T>::get_os_typespec())
   OTC_Bucket<T>(theItem);
#else
  theBucket = new OTC_Bucket<T>(theItem);
#endif
#endif
  OTCLIB_ASSERT(theBucket != 0);

  return theBucket;
}

/* ------------------------------------------------------------------------- */

#endif /* OTC_COLLCTN_DEQUE_C */
