#ifndef OTC_COLLCTN_DSCQUEUE_HH
#define OTC_COLLCTN_DSCQUEUE_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     collctn/dscqueue.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1992 1993 OTC LIMITED
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/collctn/priqueue.hh>

#ifdef __GNUG__
#if defined(EXPAND_TEMPLATES)
#pragma implementation "OTC/collctn/dscqueue.hh"
#endif
#if (__GNUC__ >= 3 || __GNUC_MINOR__ >= 6) || defined(CXX_CYGNUS)
#pragma interface "OTC/collctn/dscqueue.hh"
#else
#pragma interface
#endif
#endif

/* ------------------------------------------------------------------------- */

#ifdef __OSE_TEMPLATES__
template<class T> OTC_DescendingQueue
{
  OSE_DECLARE OTC_PriorityQueue<T>;
};
#endif

template<class T>
class OTC_DescendingQueue : public OTC_PriorityQueue<T>
    // = TITLE
    //     Implements a descending priority queue.
    //
    // = CLASS TYPE
    //     Concrete
    //
    // = DESCRIPTION
    //     This class derives from <OTC_PriorityQueue>, ensuring that the
    //     priority queue is of the descending type.
    //     
    // = SEE ALSO
    //     <OTC_PriorityQueue>
{
  public:

			~OTC_DescendingQueue();

    // = INITIALISATION

			OTC_DescendingQueue(
			 int (*theRankFn)(T const&,T const&)=0
			)
			  : OTC_PriorityQueue<T>(theRankFn,OTCLIB_DESCENDING) {}
				// Creates an empty descending priority queue.
				// <theRankFn> is an optional comparison
				// function to be used in preference to
				// <OTC_RankActions>.

			OTC_DescendingQueue(
			 OTC_DescendingQueue<T> const& theQueue
			)
                          : OTC_PriorityQueue<T>(theQueue) {}
				// Creates a queue which is a copy of
				// <theQueue>. If the queue holds pointers,
				// only the pointers are copied, not what the
				// pointers point at.

    // = ASSIGNMENT

    OTC_DescendingQueue<T>&	operator=(
				 OTC_DescendingQueue<T> const& theQueue
				)
                                {
                                  OTC_PriorityQueue<T>::operator=(theQueue);
                                  return *this;
                                }
                                // Replaces the contents of this queue, with
                                // the contents of <theQueue>. If the queue
                                // holds pointers, only the pointers are
                                // copied, not what the pointers point at.

  public:

#if defined(ENV_OSTORE)
    static os_typespec* get_os_typespec();
#endif
};

/* ------------------------------------------------------------------------- */

#if defined(EXPAND_TEMPLATES)
#include <OTC/collctn/dscqueue.c>
#endif

/* ------------------------------------------------------------------------- */

#endif /* OTC_COLLCTN_DSCQUEUE_HH */
