#ifndef OTC_COLLCTN_HASHACTN_HH
#define OTC_COLLCTN_HASHACTN_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTC
//
// = FILENAME
//     collctn/hashactn.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1991 1992 1993 OTC LIMITED
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/OTC.h>

#ifdef __GNUG__
#if defined(EXPAND_TEMPLATES)
#pragma implementation "OTC/collctn/hashactn.hh"
#if (__GNUC__ >= 3 || __GNUC_MINOR__ >= 6) || defined(CXX_CYGNUS)
#pragma interface "OTC/collctn/hashactn.hh"
#else
#pragma interface
#endif
#endif
#endif

/* ------------------------------------------------------------------------- */

template<class T>
class OTC_HashActions
    // = TITLE
    //     Default actions for calculating a hash value for an object.
    //
    // = CLASS TYPE
    //     Static
    //
    // = DESCRIPTION
    //     The default method used for determining a hash value for an
    //     object. This class may be overridden for a particular type,
    //     to define type specific behaviour.
    //     
    // = NOTES
    //     If the default behaviour is used, the type <T>, must be able to be
    //     converted to an integer.
{
  public:

#if !defined(CXX_OS)

    // = ACTIONS

    static int		hash(T const& theItem)
				{ return int(theItem); }
				// Returns a hash value for <theItem>.

#endif

  public:

#if defined(CXX_OS)
    static int		hash(T const& theItem);
#endif
};

/* ------------------------------------------------------------------------- */

#if defined(EXPAND_TEMPLATES)
#include <OTC/collctn/hashactn.c>
#endif

#ifndef OTC_COLLCTN_STRGACTN_HH
#include <OTC/collctn/strgactn.hh>
#endif

/* ------------------------------------------------------------------------- */

#endif /* OTC_COLLCTN_HASHACTN_HH */
