#ifndef OTC_COLLCTN_HASHDEFS_HH
#define OTC_COLLCTN_HASHDEFS_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     collctn/hashdefs.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 OTC LIMITED
//     Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/OTC.h>

/* ------------------------------------------------------------------------- */

// Current definitions rely on hashtable size always being a power of 2.
// If this changes, these definitions will need to be changed. The
// threshold values are as a percent, ie., 75 means 75 percent capacity.

#define OTCLIB_START_TBLSZ 16
#define OTCLIB_FLOOR_TBLSZ 256
#define OTCLIB_LOW_THRESHOLD 25
#define OTCLIB_HIGH_THRESHOLD 75

#define OTCLIB_THRESHOLD(x,t) ((u_int)(((x)*(u_int)(t))/100))

inline u_int otclib_hashtable_grow(u_int theCurrentSize)
{
  return 2 * theCurrentSize;
}

inline u_int otclib_hashtable_shrink(u_int theCurrentSize)
{
  return theCurrentSize / 2;
}

inline u_int otclib_hashtable_mask(int theHashValue, u_int theTableSize)
{
  return theHashValue & (theTableSize - 1);
}

inline int otclib_hashtable_doublehash(int theHashValue, u_int theTableSize)
{
  return otclib_hashtable_mask((theHashValue/theTableSize),theTableSize) >> 1;
}

/* ------------------------------------------------------------------------- */

#endif /* OTC_COLLCTN_HASHDEFS_HH */
