#ifndef OTC_COLLCTN_ILIST_C
#define OTC_COLLCTN_ILIST_C
/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     collctn/ilist.c
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1992 1993 OTC LIMITED
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/collctn/bucket.hh>

#ifdef __OSE_TEMPLATES__
template<class T> OTC_IList
{
  OSE_DECLARE OTC_Bucket<T>;
  OSE_IMPLEMENT OTC_Bucket<T>;
};
#endif

/* ------------------------------------------------------------------------- */
template<class T>
OTC_IList<T>::OTC_IList()
{
#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
#endif

#if defined(ENV_OSTORE_DML)
  myIter = new ((os_segment*)theLocality)
   OTC_LinkIterator(myList.list()->items());
#else
#if defined(ENV_OSTORE)
  myIter = new (theLocality,OTC_LinkIterator::get_os_typespec())
   OTC_LinkIterator(myList.list()->items());
#else
  myIter = new OTC_LinkIterator(myList.list()->items());
#endif
#endif
  OTCLIB_ASSERT(myIter != 0);
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_IList<T>::OTC_IList(OTC_IList<T> const& theList)
{
#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
#endif

#if defined(ENV_OSTORE_DML)
  myIter = new ((os_segment*)theLocality)
   OTC_LinkIterator(myList.list()->items());
#else
#if defined(ENV_OSTORE)
  myIter = new (theLocality,OTC_LinkIterator::get_os_typespec())
   OTC_LinkIterator(myList.list()->items());
#else
  myIter = new OTC_LinkIterator(myList.list()->items());
#endif
#endif
  OTCLIB_ASSERT(myIter != 0);

  OTC_LinkIterator iter = theList.myList.list()->items(OTCLIB_UNSAFE);
  for (iter.resetFirst(); iter.isLink(); iter.next())
    addLast(((OTC_Bucket<T>*)iter.link())->item());
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_IList<T>::OTC_IList(OTC_IList<T> const& theList, OTC_ShallowCopy)
  : myList(theList.myList)
{
#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
#endif

#if defined(ENV_OSTORE_DML)
  myIter = new ((os_segment*)theLocality)
   OTC_LinkIterator(myList.list()->items());
#else
#if defined(ENV_OSTORE)
  myIter = new (theLocality,OTC_LinkIterator::get_os_typespec())
   OTC_LinkIterator(myList.list()->items());
#else
  myIter = new OTC_LinkIterator(myList.list()->items());
#endif
#endif
  OTCLIB_ASSERT(myIter != 0);
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_IList<T>::~OTC_IList()
{
  myList.removeAll();
  delete myIter;
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_IList<T>& OTC_IList<T>::operator=(OTC_IList<T> const& theList)
{
  if (&theList == this)
    return *this;

  myList.removeAll();

  OTC_LinkIterator iter = theList.myList.list()->items(OTCLIB_UNSAFE);
  for (iter.resetFirst(); iter.isLink(); iter.next())
    addLast(((OTC_Bucket<T>*)iter.link())->item());

  return *this;
}

/* ------------------------------------------------------------------------- */
template<class T>
void OTC_IList<T>::addBefore(T const& theItem)
{
  OTC_Link* aBucket = _link(theItem);

  if (myIter->isStart())
  {
    myList.addFirst(aBucket);
    myIter->next();
  }
  else if (myIter->isEnd())
  {
    myList.addLast(aBucket);
    myIter->prev();
  }
  else
  {
    myList.addBeforeLink(aBucket,myIter->link());
    myIter->prev();
  }
}

/* ------------------------------------------------------------------------- */
template<class T>
void OTC_IList<T>::addAfter(T const& theItem)
{
  OTC_Link* aBucket = _link(theItem);

  if (myIter->isStart())
  {
    myList.addFirst(aBucket);
    myIter->next();
  }
  else if (myIter->isEnd())
  {
    myList.addLast(aBucket);
    myIter->prev();
  }
  else
  {
    myList.addAfterLink(aBucket,myIter->link());
    myIter->next();
  }
}

/* ------------------------------------------------------------------------- */
template<class T>
void OTC_IList<T>::remove()
{
  OTCLIB_ENSURE((myIter->isLink()),
   "OTC_IList::remove() - No item under iterator");

  if (!myIter->link()->isDead())
    myList.remove(myIter->link());
}

/* ------------------------------------------------------------------------- */
template<class T>
T& OTC_IList<T>::_item() const
{
  OTCLIB_ENSURE((myIter->isLink() && !myIter->link()->isDead()),
   "OTC_IList::_item() - No item under iterator");

  OTC_Bucket<T>* aBucket = (OTC_Bucket<T>*)myIter->link();
  return aBucket->item();
}

/* ------------------------------------------------------------------------- */
template<class T>
T& OTC_IList<T>::_first() const
{
  OTCLIB_ENSURE((!myList.isEmpty()),
   "OTC_IList::_first() - List empty");

  OTC_Bucket<T>* aBucket = (OTC_Bucket<T>*)myList.first();
  return aBucket->item();
}

/* ------------------------------------------------------------------------- */
template<class T>
T& OTC_IList<T>::_last() const
{
  OTCLIB_ENSURE((!myList.isEmpty()),
   "OTC_IList::_last() - List empty");

  OTC_Bucket<T>* aBucket = (OTC_Bucket<T>*)myList.last();
  return aBucket->item();
}

/* ------------------------------------------------------------------------- */
template<class T>
void OTC_IList<T>::apply(
 OTC_Visitor<T>& theApplicator,
 OTC_Direction theDirection,
 OTC_Protection theProtection
) const
{
  OTC_LinkIterator theIterator = myList.list()->items(theProtection);

  if (theDirection == OTCLIB_FORWARD)
    theIterator.resetFirst();
  else
    theIterator.resetLast();

  theApplicator.start();

  OTC_Progress progress = OTCLIB_CONTINUE;

  while (theIterator.isLink())
  {
    T& theItem = ((OTC_Bucket<T>*)theIterator.link())->item();
    progress = theApplicator.action(theItem);

    if (progress == OTCLIB_RESTART)
    {
      if (theDirection == OTCLIB_FORWARD)
	theIterator.resetFirst();
      else
	theIterator.resetLast();
    }
    else if (progress == OTCLIB_CONTINUE)
    {
      if (theDirection == OTCLIB_FORWARD)
	theIterator.next();
      else
	theIterator.prev();
    }
    else
      break;
  }

  theApplicator.finish();
}

/* ------------------------------------------------------------------------- */
template<class T>
void OTC_IList<T>::apply(
 OTC_Worker<T>& theApplicator,
 OTC_Direction theDirection,
 OTC_Protection theProtection
)
{
  OTC_LinkIterator theIterator = myList.list()->items(theProtection);

  if (theDirection == OTCLIB_FORWARD)
    theIterator.resetFirst();
  else
    theIterator.resetLast();

  theApplicator.start();

  OTC_Progress progress = OTCLIB_CONTINUE;

  while (theIterator.isLink())
  {
    T& theItem = ((OTC_Bucket<T>*)theIterator.link())->item();
    progress = theApplicator.action(theItem);

    if (progress == OTCLIB_RESTART)
    {
      if (theDirection == OTCLIB_FORWARD)
        theIterator.resetFirst();
      else
        theIterator.resetLast();
    }
    else if (progress == OTCLIB_CONTINUE)
    {
      if (theDirection == OTCLIB_FORWARD)
        theIterator.next();
      else
        theIterator.prev();
    }
    else
      break;
  }

  theApplicator.finish();
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_Link* OTC_IList<T>::_link(T const& theItem)
{
#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
#endif

  OTC_Bucket<T>* theBucket;
#if defined(ENV_OSTORE_DML)
  theBucket = new ((os_segment*)theLocality) OTC_Bucket<T>(theItem);
#else
#if defined(ENV_OSTORE)
  theBucket = new (theLocality,OTC_Bucket<T>::get_os_typespec())
   OTC_Bucket<T>(theItem);
#else
  theBucket = new OTC_Bucket<T>(theItem);
#endif
#endif
  OTCLIB_ASSERT(theBucket != 0);

  return theBucket;
}

/* ------------------------------------------------------------------------- */

#endif /* OTC_COLLCTN_ILIST_C */
