#ifndef OTC_COLLCTN_INDEX_C
#define OTC_COLLCTN_INDEX_C
/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     collctn/index.c
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifdef __OSE_TEMPLATES__
template<class T> OTC_Index
{
  OSE_IMPLEMENT OTC_RankActions<T>;
  OSE_IMPLEMENT OTC_IndexNode<T>;
};
#endif

/* ------------------------------------------------------------------------- */
template<class T>
OTC_Boolean OTC_Index<T>::contains(T const& theKey) const
{
  OTC_AVLNode const* theNode;

  theNode = _index.root();
  while (theNode != 0)
  {
    int theRank = _rank(theKey,((OTC_IndexNode<T> const*)theNode)->key());
    if (theRank == 0)
      return OTCLIB_TRUE;
    else if (theRank < 0)
      theNode = theNode->left();
    else
      theNode = theNode->right();
  }
  return OTCLIB_FALSE;
}

/* ------------------------------------------------------------------------- */
template<class T>
int OTC_Index<T>::index(T const& theKey) const
{
  OTC_IndexNode<T> const* theNode;

  theNode = _node(theKey);
  if (theNode == 0)
    return -1;

  return theNode->index();
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_IndexNode<T>* OTC_Index<T>::insert(T const& theKey)
{
  OTC_AVLNode* theNode = 0;
  OTC_AVLNode* theParent = 0;
  int theRank = 0;

  theNode = _index.root();
  if (theNode == 0)
  {
#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
    OTC_Locality theLocality = OTC_Locality::of(this);
#endif

#if defined(ENV_OSTORE_DML)
    theNode = new ((os_segment*)theLocality) OTC_IndexNode<T>(theKey);
#else
#if defined(ENV_OSTORE)
    theNode = new (theLocality,OTC_IndexNode<T>::get_os_typespec())
     OTC_IndexNode<T>(theKey);
#else
    theNode = new OTC_IndexNode<T>(theKey);
#endif
#endif
    OTCLIB_ASSERT(theNode != 0);
    _index.addRoot(theNode);
  }
  else
  {
    while (theNode != 0)
    {
      theParent = theNode;
      theRank = _rank(theKey,((OTC_IndexNode<T>*)theNode)->key());
      if (theRank == 0)
	break;
      else if (theRank < 0)
	theNode = theNode->left();
      else
	theNode = theNode->right();
    }

    if (theNode == 0)
    {
#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
      OTC_Locality theLocality = OTC_Locality::of(this);
#endif

#if defined(ENV_OSTORE_DML)
      theNode = new ((os_segment*)theLocality) OTC_IndexNode<T>(theKey);
#else
#if defined(ENV_OSTORE)
      theNode = new (theLocality,OTC_IndexNode<T>::get_os_typespec())
       OTC_IndexNode<T>(theKey);
#else
      theNode = new OTC_IndexNode<T>(theKey);
#endif
#endif
      OTCLIB_ASSERT(theNode != 0);
      if (theRank < 0)
	theParent->addBefore(theNode);
      else
	theParent->addAfter(theNode);
    }
  }

  return (OTC_IndexNode<T>*)theNode;
}

/* ------------------------------------------------------------------------- */
template<class T>
void OTC_Index<T>::removeAtIndex(u_int theIndex)
{
  OTC_AVLNode* theNode;

  theNode = _index.node(theIndex);
  if (theNode != 0)
  {
    theNode->unlink();
    delete theNode;
  }
}

/* ------------------------------------------------------------------------- */
template<class T>
void OTC_Index<T>::remove(T const& theKey)
{
  OTC_AVLNode* theNode;

  theNode = _index.root();
  while (theNode != 0)
  {
    int theRank = _rank(theKey,((OTC_IndexNode<T> const*)theNode)->key());
    if (theRank == 0)
    {
      theNode->unlink();
      delete theNode;
      break;
    }
    else if (theRank < 0)
      theNode = theNode->left();
    else
      theNode = theNode->right();
  }
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_IndexNode<T>* OTC_Index<T>::_node(T const& theKey) const
{
  OTC_AVLNode* theNode;

  theNode = (OTC_AVLNode*)_index.root();
  while (theNode != 0)
  {
    int theRank = _rank(theKey,((OTC_IndexNode<T> const*)theNode)->key());
    if (theRank == 0)
      return (OTC_IndexNode<T>*)theNode;
    else if (theRank < 0)
      theNode = theNode->left();
    else
      theNode = theNode->right();
  }
  return 0;
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_IndexNode<T>* OTC_Index<T>::_nodeAtIndex(u_int theIndex) const
{
  OTC_AVLNode* theNode;

  theNode = (OTC_AVLNode*)_index.node(theIndex);
  if (theNode == 0)
    return 0;

  return (OTC_IndexNode<T>*)theNode;
}

/* ------------------------------------------------------------------------- */
template<class T>
int OTC_Index<T>::_rank(T const& item1, T const& item2) const
{
  return (_rankFn != 0) ? (*_rankFn)(item1,item2) :
   OTC_RankActions<T>::rank(item1,item2);
}

/* ------------------------------------------------------------------------- */

#endif
