#ifndef OTC_COLLCTN_INDXNODE_HH
#define OTC_COLLCTN_INDXNODE_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     collctn/indxnode.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/collctn/avlnode.hh>
#include <OTC/collctn/baseactn.hh>

#ifdef __GNUG__
#if defined(EXPAND_TEMPLATES)
#pragma implementation "OTC/collctn/indxnode.hh"
#endif
#if (__GNUC__ >= 3 || __GNUC_MINOR__ >= 6) || defined(CXX_CYGNUS)
#pragma interface "OTC/collctn/indxnode.hh"
#else
#pragma interface
#endif
#endif

/* ------------------------------------------------------------------------- */

#ifdef __OSE_TEMPLATES__
template<class T> OTC_IndexNode
{
  OSE_DECLARE OTC_BaseActions<T>;
};
#endif

template<class T>
class OTC_IndexNode : public OTC_AVLNode
    // = TITLE
    //     AVL tree node for holding a key and item.
    //
    // = CLASS TYPE
    //     Concrete
    //
    // = DESCRIPTION
    //     This class is a derived version of <OTC_AVLNode> and allows
    //     the node to contain a key and item, where the item is stored
    //     as a void pointer. The keys are managed by <OTC_BaseActions>,
    //     the void pointers items are not. Therefore you are responsible
    //     for deleting any item held.
    //
    // = SEE ALSO
    //     <OTC_AVLNode>, <OTC_AVLTree>, <OTC_BaseActions>
{
  public:

    // = DESTRUCTION

			~OTC_IndexNode();
				// This does not delete the item held. This
				// must be done explicitly by the user of the
				// class if required.

    // = INITIALISATION

			OTC_IndexNode(T const& theKey);
				// Creates a node to hold <theKey>. The
				// pointer for the item is initialised
				// to <0>.

    // = NAMING

    T const&		key() const
				{ return _key; }
				// Returns the key.

    // = LINK

    void*		item()
				{ return _item; }
				// Returns the item.

    void const*		item() const
				{ return _item; }
				// Returns the item.

    void		setItem(void* theItem)
				{ _item = theItem; }
				// Sets the item to <theItem>.

  public:

#if defined(ENV_OSTORE) && !defined(SCHEMA_GENERATION)
    static os_typespec* get_os_typespec();
#endif

  private:

			OTC_IndexNode(OTC_IndexNode<T> const&)
				{ terminate(); }
				// Do not define an implementation for this.

    OTC_IndexNode<T>&	operator=(OTC_IndexNode<T> const&)
				{ terminate(); return *this; }
				// Do not define an implementation for this.

    T			_key;
				// The key.

    void*		_item;
				// The item.
};

/* ------------------------------------------------------------------------- */

#if defined(EXPAND_TEMPLATES)
#include <OTC/collctn/indxnode.c>
#endif

/* ------------------------------------------------------------------------- */

#endif /* OTC_COLLCTN_INDXNODE_HH */
