#ifndef OTC_COLLCTN_KCURSOR_C
#define OTC_COLLCTN_KCURSOR_C
/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     collctn/kcursor.c
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 TELSTRA CORPORATION LIMITED
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

/* ------------------------------------------------------------------------- */
#ifdef __OSE_TEMPLATES__
template<class T, class L> OTC_KeyCursor
{
  OSE_IMPLEMENT OTC_Cursor<T>;
};
#endif

#if defined(ENV_OSTORE)
/* ------------------------------------------------------------------------- */
template<class T, class L>
os_typespec* OTC_KeyCursor<T,L>::typespec()
{
  static os_typespec ts("OTC_KeyCursor<int,OTC_IILink>");
  return &ts;
}
#endif

/* ------------------------------------------------------------------------- */
#if !(__GNUG__ == 2 && __GNUC_MINOR__ == 5)
template<class T, class L>
OTC_KeyCursor<T,L>::~OTC_KeyCursor()
{
  // Nothing to do.
}
#endif

/* ------------------------------------------------------------------------- */
template<class T, class L>
OTC_KeyCursor<T,L>::OTC_KeyCursor(
 OTC_LinkList* aList,
 OTC_Direction theDirection,
 OTC_Protection theProtection
)
 : OTC_LinkCursor(aList,theDirection,theProtection)
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
template<class T, class L>
OTC_KeyCursor<T,L>::OTC_KeyCursor(
 OTC_LinkList* aList,
 OTC_Linkable* theStart,
 OTC_Linkable* theEnd,
 OTC_Direction theDirection,
 OTC_Protection theProtection
)
 : OTC_LinkCursor(aList,theStart,theEnd,theDirection,theProtection)
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
template<class T, class L>
OTC_KeyCursor<T,L>::OTC_KeyCursor(OTC_KeyCursor<T,L> const& theIter)
 : OTC_LinkCursor(theIter)
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
template<class T, class L>
void OTC_KeyCursor<T,L>::reset()
{
  OTC_LinkCursor::reset();
}

/* ------------------------------------------------------------------------- */
template<class T, class L>
T& OTC_KeyCursor<T,L>::item()
{
  OTCLIB_ENSURE((OTC_LinkCursor::isValid()),
   "OTC_KeyCursor::item() - No item under cursor");

  return ((L*)OTC_LinkCursor::link())->key();
}

/* ------------------------------------------------------------------------- */
template<class T, class L>
void OTC_KeyCursor<T,L>::next()
{
  OTC_LinkCursor::next();
}

/* ------------------------------------------------------------------------- */
template<class T, class L>
OTC_Boolean OTC_KeyCursor<T,L>::isValid() const
{
  return OTC_LinkCursor::isValid();
}

/* ------------------------------------------------------------------------- */
template<class T, class L>
OTC_Cursor<T>* OTC_KeyCursor<T,L>::clone()
{
#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
#endif

  OTC_KeyCursor<T,L>* theIter;
#if defined(ENV_OSTORE_DML)
  theIter = new ((os_segment*)theLocality) OTC_KeyCursor<T,L>(*this);
#else
#if defined(ENV_OSTORE)
  theIter = new (theLocality,OTC_KeyCursor<T,L>::get_os_typespec())
   OTC_KeyCursor<T,L>(*this);
#else
  theIter = new OTC_KeyCursor<T,L>(*this);
#endif
#endif
  OTCLIB_ASSERT(theIter != 0);
  return theIter;
}

/* ------------------------------------------------------------------------- */

#endif /* OTC_COLLCTN_KCURSOR_C */
