#ifndef OTC_COLLCTN_KICURSOR_C
#define OTC_COLLCTN_KICURSOR_C
/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     collctn/kicursor.c
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 TELSTRA CORPORATION LIMITED
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

/* ------------------------------------------------------------------------- */
#ifdef __OSE_TEMPLATES__
template<class T1, class T2, class L> OTC_KeyItemCursor
{
  OSE_IMPLEMENT OTC_PairCursor<T1,T2>;
};
#endif

#if defined(ENV_OSTORE)
/* ------------------------------------------------------------------------- */
template<class T1, class T2, class L>
os_typespec* OTC_KeyItemCursor<T1,T2,L>::typespec()
{
  static os_typespec ts("OTC_KeyItemCursor<int,int,OTC_IILink>");
  return &ts;
}
#endif

/* ------------------------------------------------------------------------- */
#if !(__GNUG__ == 2 && __GNUC_MINOR__ == 5)
template<class T1, class T2, class L>
OTC_KeyItemCursor<T1,T2,L>::~OTC_KeyItemCursor()
{
  // Nothing to do.
}
#endif

/* ------------------------------------------------------------------------- */
template<class T1, class T2, class L>
OTC_KeyItemCursor<T1,T2,L>::OTC_KeyItemCursor(
 OTC_LinkList* aList,
 OTC_Direction theDirection,
 OTC_Protection theProtection
)
 : OTC_LinkCursor(aList,theDirection,theProtection)
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
template<class T1, class T2, class L>
OTC_KeyItemCursor<T1,T2,L>::OTC_KeyItemCursor(
 OTC_LinkList* aList,
 OTC_Linkable* theStart,
 OTC_Linkable* theEnd,
 OTC_Direction theDirection,
 OTC_Protection theProtection
)
 : OTC_LinkCursor(aList,theStart,theEnd,theDirection,theProtection)
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
template<class T1, class T2, class L>
OTC_KeyItemCursor<T1,T2,L>::OTC_KeyItemCursor(
 OTC_KeyItemCursor<T1,T2,L> const& theIter
)
 : OTC_LinkCursor(theIter)
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
template<class T1, class T2, class L>
void OTC_KeyItemCursor<T1,T2,L>::reset()
{
  OTC_LinkCursor::reset();
}

/* ------------------------------------------------------------------------- */
template<class T1, class T2, class L>
T1& OTC_KeyItemCursor<T1,T2,L>::key()
{
  OTCLIB_ENSURE((OTC_LinkCursor::isValid()),
   "OTC_KeyItemCursor::key() - No item under cursor");

  return ((L*)OTC_LinkCursor::link())->key();
}

/* ------------------------------------------------------------------------- */
template<class T1, class T2, class L>
T2& OTC_KeyItemCursor<T1,T2,L>::item()
{
  OTCLIB_ENSURE((OTC_LinkCursor::isValid()),
   "OTC_KeyItemCursor::item() - No item under cursor");

  return ((L*)OTC_LinkCursor::link())->item();
}

/* ------------------------------------------------------------------------- */
template<class T1, class T2, class L>
void OTC_KeyItemCursor<T1,T2,L>::next()
{
  OTC_LinkCursor::next();
}

/* ------------------------------------------------------------------------- */
template<class T1, class T2, class L>
OTC_Boolean OTC_KeyItemCursor<T1,T2,L>::isValid() const
{
  return OTC_LinkCursor::isValid();
}

/* ------------------------------------------------------------------------- */
template<class T1, class T2, class L>
OTC_PairCursor<T1,T2>* OTC_KeyItemCursor<T1,T2,L>::clone()
{
#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
#endif

  OTC_KeyItemCursor<T1,T2,L>* theIter;
#if defined(ENV_OSTORE_DML)
  theIter = new ((os_segment*)theLocality) OTC_KeyItemCursor<T1,T2,L>(*this);
#else
#if defined(ENV_OSTORE)
  theIter = new (theLocality,
   OTC_KeyItemCursor<T1,T2,L>::get_os_typespec())
   OTC_KeyItemCursor<T1,T2,L>(*this);
#else
  theIter = new OTC_KeyItemCursor<T1,T2,L>(*this);
#endif
#endif
  OTCLIB_ASSERT(theIter != 0);
  return theIter;
}

/* ------------------------------------------------------------------------- */

#endif /* OTC_COLLCTN_KICURSOR_C */
