#ifndef OTC_COLLCTN_MLIST_C
#define OTC_COLLCTN_MLIST_C
/*
// ============================================================================
//
// = LIBRARY
//     OTC
//
// = FILENAME
//     collctn/mlist.c
// 
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

/* ------------------------------------------------------------------------- */
#ifdef __OSE_TEMPLATES__
template<class T> OTC_MList
{
  OSE_IMPLEMENT OTC_Bucket<T>;
};
#endif

/* ------------------------------------------------------------------------- */
template<class T>
OTC_MList<T>::OTC_MList(OTC_MList<T> const& theList)
{
  OTC_LinkIterator iter = theList.myList.list()->items(OTCLIB_UNSAFE);
  for (iter.resetFirst(); iter.isLink(); iter.next())
    addLast(((OTC_Bucket<T>*)iter.link())->item());
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_MList<T>& OTC_MList<T>::operator=(OTC_MList<T> const& theList)
{
  if (&theList != this)
  {
    removeAll();
    OTC_LinkIterator iter = theList.myList.list()->items(OTCLIB_UNSAFE);
    for (iter.resetFirst(); iter.isLink(); iter.next())
      addLast(((OTC_Bucket<T>*)iter.link())->item());
  }
  return *this;
}

/* ------------------------------------------------------------------------- */
template<class T>
void OTC_MList<T>::apply(
 OTC_Visitor<T>& theApplicator,
 OTC_Direction theDirection,
 OTC_Protection theProtection
) const
{
  OTC_LinkIterator theIterator = myList.list()->items(theProtection);

  if (theDirection == OTCLIB_FORWARD)
    theIterator.resetFirst();
  else
    theIterator.resetLast();

  theApplicator.start();

  OTC_Progress progress = OTCLIB_CONTINUE;

  while (theIterator.isLink())
  {
    T& theItem = ((OTC_Bucket<T>*)theIterator.link())->item();
    progress = theApplicator.action(theItem);

    if (progress == OTCLIB_RESTART)
    {
      if (theDirection == OTCLIB_FORWARD)
	theIterator.resetFirst();
      else
	theIterator.resetLast();
    }
    else if (progress == OTCLIB_CONTINUE)
    {
      if (theDirection == OTCLIB_FORWARD)
	theIterator.next();
      else
	theIterator.prev();
    }
    else
      break;
  }

  theApplicator.finish();
}

/* ------------------------------------------------------------------------- */
template<class T>
void OTC_MList<T>::apply(
 OTC_Worker<T>& theApplicator,
 OTC_Direction theDirection,
 OTC_Protection theProtection
)
{
  OTC_LinkIterator theIterator = myList.list()->items(theProtection);

  if (theDirection == OTCLIB_FORWARD)
    theIterator.resetFirst();
  else
    theIterator.resetLast();

  theApplicator.start();

  OTC_Progress progress = OTCLIB_CONTINUE;

  while (theIterator.isLink())
  {
    T& theItem = ((OTC_Bucket<T>*)theIterator.link())->item();
    progress = theApplicator.action(theItem);

    if (progress == OTCLIB_RESTART)
    {
      if (theDirection == OTCLIB_FORWARD)
	theIterator.resetFirst();
      else
	theIterator.resetLast();
    }
    else if (progress == OTCLIB_CONTINUE)
    {
      if (theDirection == OTCLIB_FORWARD)
	theIterator.next();
      else
	theIterator.prev();
    }
    else
      break;
  }

  theApplicator.finish();
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_Link* OTC_MList<T>::_link(T const& theItem)
{
#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
#endif

  OTC_Bucket<T>* theBucket;
#if defined(ENV_OSTORE_DML)
  theBucket = new ((os_segment*)theLocality) OTC_Bucket<T>(theItem);
#else
#if defined(ENV_OSTORE)
  theBucket = new (theLocality,OTC_Bucket<T>::get_os_typespec())
   OTC_Bucket<T>(theItem);
#else
  theBucket = new OTC_Bucket<T>(theItem);
#endif
#endif
  OTCLIB_ASSERT(theBucket != 0);

  return theBucket;
}

/* ------------------------------------------------------------------------- */

#endif /* OTC_COLLCTN_MLIST_C */
