#ifndef OTC_COLLCTN_MLIST_HH
#define OTC_COLLCTN_MLIST_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTC
//
// = FILENAME
//     collctn/mlist.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/collctn/dequei.hh>
#include <OTC/collctn/shlwcopy.hh>
#include <OTC/collctn/bucket.hh>
#include <OTC/collctn/worker.hh>
#include <OTC/collctn/visitor.hh>
#include <OTC/collctn/dirction.hh>
#include <OTC/collctn/prtction.hh>

#ifdef __GNUG__
#if defined(EXPAND_TEMPLATES)
#pragma implementation "OTC/collctn/mlist.hh"
#endif
#if (__GNUC__ >= 3 || __GNUC_MINOR__ >= 6) || defined(CXX_CYGNUS)
#pragma interface "OTC/collctn/mlist.hh"
#else
#pragma interface
#endif
#endif

/* ------------------------------------------------------------------------- */

#ifdef __OSE_TEMPLATES__
template<class T> OTC_MList
{
  OSE_DECLARE OTC_Bucket<T>;
  OSE_DECLARE OTC_Visitor<T>;
  OSE_DECLARE OTC_Worker<T>;
};
#endif

template<class T> class OTC_MListIterator;

template<class T>
class OTC_MList
    // = TITLE
    //	   A list class which can be modified through an iterator(modifier).
    //
    // = CLASS TYPE
    //	   Concrete
    //
    // = DESCRIPTION
    //	   <OTC_MList> implements a list of objects where access to and
    //	   manipulation of items, is permitted on items occurring at the
    //	   ends of the list. Manipulation and removal of items may also
    //	   be achieved through a separate class specific iterator and
    //	   modifier.
    //	   
    // = NOTES
    //	   The <OTC_Bucket> class is used internally to hold items in the
    //	   list. Thus, the <OTC_BaseActions> class may be used to provide
    //	   actions to be performed, when items are inserted and removed from
    //	   the list.
    //
    // = SEE ALSO
    //	   <OTC_Bucket>, <OTC_BaseActions>, <OTC_MListIterator>,
    //	   <OTC_MListModifier>
{
    friend		class OTC_MListIterator<T>;

  public:

    // = INITIALISATION

			OTC_MList() {}
				// Creates an empty list.

			OTC_MList(OTC_MList<T> const& theList);
				// Creates a copy of <theList>.

			OTC_MList(OTC_MList<T>& theList, OTC_ShallowCopy)
			  : myList(theList.myList) {}
				// Creates an alias for <theList>.

    // = ASSIGNMENT

    OTC_MList<T>&	operator=(OTC_MList<T> const& theList);
				// Replaces the contents of this list with
				// the items contained in <theList>.

    // = QUERY

    u_int		population() const
				{ return myList.population(); }
				// Returns the number of items in the
				// list.

    OTC_Boolean		isEmpty() const
				{ return myList.isEmpty(); }
				// Returns <OTCLIB_TRUE> if the the list
				// is empty.

    // = ADDITION

    void		addFirst(T const& theItem)
				{ myList.addFirst(_link(theItem)); }
				// Inserts <theItem> at the head of the list.

    void		addLast(T const& theItem)
				{ myList.addLast(_link(theItem)); }
				// Appends <theItem> to the tail of the list.

    // = ACCESS

    T&			first()
				{
				  return ((OTC_Bucket<T>*)
				   myList.first())->item();
				}
				// Returns a reference to the first item in
				// the list. If the list is empty, an
				// exception is raised.

    T const&		first() const
				{
				  return ((OTC_Bucket<T>*)
				   myList.first())->item();
				}
				// Returns a reference to the first item in
				// the list. If the list is empty, an
				// exception is raised.

    T&			last()
				{
				  return ((OTC_Bucket<T>*)
				   myList.last())->item();
				}
				// Returns a reference to the last item in
				// the list. If the list is empty, an
				// exception is raised.

    T const&		last() const
				{
				  return ((OTC_Bucket<T>*)
				   myList.last())->item();
				}
				// Returns a reference to the last item in
				// the list. If the list is empty, an
				// exception is raised.

    T*			pFirst()
				{
				  return myList.isEmpty() ? 0 :
				   &((OTC_Bucket<T>*)myList.first())->item();
				}
				// Returns a pointer to the first item in
				// the list. If the list is empty, a null
				// pointer is returned.

    T const*		pFirst() const
				{
				  return myList.isEmpty() ? 0 :
				   &((OTC_Bucket<T>*)myList.first())->item();
				}
				// Returns a pointer to the first item in
				// the list. If the list is empty, a null
				// pointer is returned.

    T*			pLast()
				{
				  return myList.isEmpty() ? 0 :
				   &((OTC_Bucket<T>*)myList.last())->item();
				}
				// Returns a pointer to the last item in
				// the list. If the list is empty, a null
				// pointer is returned.

    T const*		pLast() const
				{
				  return myList.isEmpty() ? 0 :
				   &((OTC_Bucket<T>*)myList.last())->item();
				}
				// Returns a pointer to the last item in
				// the list. If the list is empty, a null
				// pointer is returned.

    // = REMOVAL

    void		removeAll()
				{ myList.removeAll(); }
				// Removes all items from the list.

    void		removeFirst()
				{ myList.removeFirst(); }
				// Removes the first item in the list. If
				// the list is empty, an exception is
				// raised.

    void		removeLast()
				{ myList.removeLast(); }
				// Removes the first item in the list. If
				// the list is empty, an exception is
				// raised.

    // = APPLICATORS

    void		apply(
			 OTC_Visitor<T>& theApplicator,
			 OTC_Direction theDirection=OTCLIB_FORWARD,
			 OTC_Protection theProtection=OTCLIB_SAFE
			) const;
				// Applies <theApplicator> to each of the
				// items in the collection. The direction
				// being determined by <theDirection>. Valid
				// values are <OTCLIB_FORWARD> and
				// <OTCLIB_BACKWARD>.

    void		apply(
			 OTC_Worker<T>& theApplicator,
			 OTC_Direction theDirection=OTCLIB_FORWARD,
			 OTC_Protection theProtection=OTCLIB_SAFE
			);
				// Applies <theApplicator> to each of the
				// items in the collection. The direction
				// being determined by <theDirection>. Valid
				// values are <OTCLIB_FORWARD> and
				// <OTCLIB_BACKWARD>.

  public:

#if defined(ENV_OSTORE)
    static os_typespec* get_os_typespec();
#endif

  private:

    OTC_Link*		_link(T const& theItem);
				// Creates an instance of <OTC_Bucket>
				// to hold <theItem>.

    OTC_DequeI		myList;
};

/* ------------------------------------------------------------------------- */

#if defined(EXPAND_TEMPLATES)
#include <OTC/collctn/mlist.c>
#endif

#ifndef OTC_COLLCTN_MLSTITER_HH
#include <OTC/collctn/mlstiter.hh>
#endif

#ifndef OTC_COLLCTN_MLSTMDFR_HH
#include <OTC/collctn/mlstmdfr.hh>
#endif

/* ------------------------------------------------------------------------- */

#endif /* OTC_COLLCTN_MLIST_HH */
