#ifndef OTC_COLLCTN_MLSTMDFR_HH
#define OTC_COLLCTN_MLSTMDFR_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     collctn/mlstmdfr.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifndef OTC_COLLCTN_MLIST_HH
#include <OTC/collctn/mlist.hh>
#endif

#ifndef OTC_COLLCTN_MLSTITER_HH
#include <OTC/collctn/mlstiter.hh>
#endif

#ifdef __GNUG__
#if defined(EXPAND_TEMPLATES)
#pragma implementation "OTC/collctn/mlstmdfr.hh"
#if (__GNUC__ >= 3 || __GNUC_MINOR__ >= 6) || defined(CXX_CYGNUS)
#pragma interface "OTC/collctn/mlstmdfr.hh"
#else
#pragma interface
#endif
#endif
#endif

/* ------------------------------------------------------------------------- */

template<class T>
class OTC_MListModifier : public OTC_MListIterator<T>
    // = TITLE
    //	   Inherits from <OTC_MListIterator> to allow modification of items.
    //
    // = CLASS TYPE
    //	   Concrete
    //
    // = DESCRIPTION
    //	   This class inherits from <OTC_MListIterator> to allow modification
    //	   of items held by an instance of <OTC_MList>. Items in the list can
    //	   also be removed using the iterator.
    //	   
    //	   This iterator can be moved both forward and backwards. The
    //	   life of the iterator, cannot extend beyond the life of the
    //	   list being iterated over.
    //
    // = SEE ALSO
    //	   <OTC_MListIterator>
{
  public:

    // = INITIALISATION

			OTC_MListModifier(OTC_MListModifier<T> const& theIter)
			  : OTC_MListIterator<T>(theIter) {}
				// Creates an iterator which is inititally
				// located at the same position as <theIter>.
				// The iterator will operate independently of
				// <theIter>.

			OTC_MListModifier(
			 OTC_MList<T>& theList,
			 OTC_Protection theProtection=OTCLIB_SAFE
			)
			  : OTC_MListIterator<T>(theList,theProtection)
				{}
				// Initialises the iterator. The iterator
				// will be located over the first item in
				// <theList>, or if the list is empty at the
				// start of the list. The argument
				// <theProtection> determines if reference
				// counting will actually be performed on
				// links in the list. The default of
				// <OTCLIB_SAFE> will result in reference
				// counting being performed. A value of
				// <OTCLIB_UNSAFE> will turn of reference
				// counting. In this later case, the list
				// should not be modified while the iterator
				// exists as the state of the iterator will
				// be corrupted.

    // = RETRIEVAL

    T&			item() const
				{ return _item(); }
				// Returns the item under the current
				// location of the iterator. Raises an
				// exception if there is no item under the
				// iterator.

    // = REMOVAL

    void		remove()
				{ _remove(); }
				// If the iterator is located on a valid item
				// in the list, the item is removed from the
				// list.

    // = ADDITION

    void		addBefore(T const& theItem)
				{ _addBefore(theItem); }
				// Adds <theItem> in the list before the
				// item where the iterator is currently
				// located. If the iterator is at the
				// start of the list, the item will be
				// added as the first item in the list.

    void		addAfter(T const& theItem)
				{ _addAfter(theItem); }
				// Adds <theItem> in the list after the
				// item where the iterator is currently
				// located. If the iterator is at the
				// end of the list, the item will be
				// added as the last item in the list.

  private:

    OTC_MListModifier<T>&	operator=(OTC_MListModifier<T> const&)
				{ terminate(); return *this; }
				// Do not define an implementation for this.
};

/* ------------------------------------------------------------------------- */

#endif /* OTC_COLLCTN_MLSTMDFR_HH */
