#ifndef OTC_COLLCTN_MODIFIER_HH
#define OTC_COLLCTN_MODIFIER_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTC
//
// = FILENAME
//     collctn/modifier.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1991 1992 1993 OTC LIMITED
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/collctn/iterator.hh>

#ifdef __GNUG__
#if defined(EXPAND_TEMPLATES)
#pragma implementation "OTC/collctn/modifier.hh"
#if (__GNUC__ >= 3 || __GNUC_MINOR__ >= 6) || defined(CXX_CYGNUS)
#pragma interface "OTC/collctn/modifier.hh"
#else
#pragma interface
#endif
#endif
#endif

/* ------------------------------------------------------------------------- */

#ifdef __OSE_TEMPLATES__
template<class T> OTC_Modifier
{
  OSE_DECLARE OTC_Iterator<T>;
};
#endif

template<class T>
class OTC_Modifier : public OTC_Iterator<T>
    // = TITLE
    //     Smart pointer for iterators. Allows modification of items.
    //
    // = CLASS TYPE
    //     Concrete
    //
    // = DESCRIPTION
    //     This class exists so that the user of an iterator for a particular
    //     type of collection, does not have to worry about deleting the
    //     iterator when finished with it. This class will ensure
    //     that the iterator is destroyed when this class goes out of scope.
    //     In order for this to work correctly, an instance of this class
    //     should never be created using <new>.
    //
    // = EXAMPLE
    //
    // = BEGIN<CODE>
    //     void inc(OTC_List<int>& aList)
    //     {
    //       OTC_Modifier<int> anIter = 0;
    //       anIter = aList.items();
    //       for (anIter.reset(); anIter.isValid(); anIter.next())
    //         anIter.item()++;
    //     }
    // = END<CODE>
    //
    // = SEE ALSO
    //     <OTC_Iterator>
{
  public:

			~OTC_Modifier() {}

    // = INITIALISATION

			OTC_Modifier() {}
				// Creates a null iterator.

			OTC_Modifier(OTC_Cursor<T>* anIter)
			  : OTC_Iterator<T>(anIter) {}
				// Constructor used when an iterator
				// for a particular type of collection is
				// first created. If <anIter> is <0> a
				// null iterator is constructed.

			OTC_Modifier(OTC_Modifier<T> const& anIter)
			  : OTC_Iterator<T>(anIter) {}
				// Copy constructor for when an iterator is
				// used as return type.

    OTC_Modifier<T>&	operator=(OTC_Cursor<T>* anIter)
				{
				  OTC_Iterator<T>::operator=(anIter);
				  return *this;
				}
				// Sets this iterator to <anIter>.
				// If <anIter> is <0>, the iterator
				// is turned into a null iterator and
				// all associations with the previous
				// collection are lost.

    OTC_Modifier<T>&	operator=(OTC_Modifier<T> const& anIter)
				{
				  OTC_Iterator<T>::operator=(anIter);
				  return *this;
				}
				// Sets this iterator to <anIter>.

    // = RETRIEVAL

    T&			item() const
				{ return _item(); }
				// Returns the item under the current
				// location of the iterator. If no such item
				// exists, or this is a null iterator, an
				// exception is raised.

    // = CLONING

    OTC_Modifier<T>	clone() const
				{ return _clone(); }
				// Returns an iterator which is
                                // a clone of this iterator. The new
                                // iterator will initially be located
                                // over the same item as this iterator,
                                // however, subsequent operations will be
                                // independent of this iterator.

    // = APPLICATOR

#if !defined(ENV_NOAPPLICATORS)

    void                apply(OTC_Visitor<T>& theApplicator)
				{ _apply(theApplicator); }
                                // Applies <theApplicator> to each item
                                // accessible by this iterator.

    void                apply(OTC_Worker<T>& theApplicator)
				{ _apply(theApplicator); }
                                // Applies <theApplicator> to each item
                                // accessible by this iterator.

#endif

  public:

#if defined(ENV_OSTORE)
    static os_typespec* get_os_typespec();
#endif
};

/* ------------------------------------------------------------------------- */

#if defined(EXPAND_TEMPLATES)
#ifdef __OSE_TEMPLATES__
template<class T> OTC_Modifier
{
  OSE_IMPLEMENT OTC_Iterator<T>;
};
#endif
#endif

/* ------------------------------------------------------------------------- */

#endif /* OTC_COLLCTN_MODIFIER_HH */
