#ifndef OTC_COLLCTN_PAIR_HH
#define OTC_COLLCTN_PAIR_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     collctn/pair.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 TELSTRA CORPORATION LIMITED
//     Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/memory/mpobject.hh>

#ifdef __GNUG__
#if defined(EXPAND_TEMPLATES)
#pragma implementation "OTC/collctn/pair.hh"
#if (__GNUC__ >= 3 || __GNUC_MINOR__ >= 6) || defined(CXX_CYGNUS)
#pragma interface "OTC/collctn/pair.hh"
#else
#pragma interface
#endif
#endif
#endif

/* ------------------------------------------------------------------------- */

template<class T1, class T2>
class OTC_Pair : public OTC_MPObject
    // = TITLE
    //     Template class for encapsulating a pair of values.
    //
    // = CLASS TYPE
    //     Concrete
    //
    // = DESCRIPTION
    //     The <OTC_Pair> class can be used to encapsulate a pair of simple
    //     values. This facilitates returning of a pair of values from a
    //     function. The class also allows allocation of a pair of objects
    //     in the common memory pool.
    //
    // = SEE ALSO
    //     <OTC_Single>, <OTC_Triple>
{
  public:

    // = INITIALISATION

			OTC_Pair(T1 const& theFirst, T2 const& theSecond)
			  : myFirst(theFirst), mySecond(theSecond)
				{}
				// Sets the values of this pair to <theFirst>
				// and <theSecond>.

			OTC_Pair(OTC_Pair<T1,T2> const& thePair)
			  : myFirst(thePair.myFirst), mySecond(thePair.mySecond)
				{}
				// Sets the values of this pair to that
				// of <thePair>.

    // = ASSIGNMENT

    OTC_Pair<T1,T2>&	operator=(OTC_Pair<T1,T2> const& thePair)
				{
				  myFirst = thePair.myFirst;
				  mySecond = thePair.mySecond;
				  return *this;
				}
				// Sets the values of this pair to that
				// of <thePair>.

    // = ACCESS

    T1 const&		first() const
				{ return myFirst; }
				// Returns the first item in the pair.

    T1&			first()
				{ return myFirst; }
				// Returns the first item in the pair.

    T2 const&		second() const
				{ return mySecond; }
				// Returns the second item in the pair.

    T2&			second()
				{ return mySecond; }
				// Returns the second item in the pair.

  public:

#if defined(ENV_OSTORE)
    static os_typespec* get_os_typespec();
#endif

  private:

    T1			myFirst;
				// First item in the pair.

    T2			mySecond;
				// Second item in the pair.
};

/* ------------------------------------------------------------------------- */

#endif /* OTC_COLLCTN_PAIR_HH */
