#ifndef OTC_COLLCTN_PRBUCKET_C
#define OTC_COLLCTN_PRBUCKET_C
/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     collctn/prbucket.c
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 TELSTRA CORPORATION LIMITED
//     Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#ifdef __OSE_TEMPLATES__
template<class T1, class T2> OTC_PairBucket
{
  OSE_IMPLEMENT OTC_Bucket<T2>;
  OSE_IMPLEMENT OTC_BaseActions<T1>;
};
#endif

/* ------------------------------------------------------------------------- */
#if !(__GNUG__ == 2 && __GNUC_MINOR__ == 5)
template<class T1, class T2>
OTC_PairBucket<T1,T2>::~OTC_PairBucket()
{
  OTC_BaseActions<T1>::remove(myKey);
}
#endif

#if !defined(ENV_OSTORE) || !defined(SCHEMA_GENERATION)
/* ------------------------------------------------------------------------- */
template<class T1, class T2>
OTC_PairBucket<T1,T2>::OTC_PairBucket(OTC_PairBucket<T1,T2> const& theBucket)
  : myKey(OTC_BaseActions<T1>::add(theBucket.myKey)), OTC_Bucket<T2>(theBucket)
{
  // Nothing to do.
}

/* ------------------------------------------------------------------------- */
template<class T1, class T2>
OTC_PairBucket<T1,T2>::OTC_PairBucket(T1 const& theKey, T2 const& theItem)
  : myKey(OTC_BaseActions<T1>::add(theKey)), OTC_Bucket<T2>(theItem)
{
  // Nothing to do.
}
#endif

/* ------------------------------------------------------------------------- */

#endif /* OTC_COLLCTN_PRBUCKET_C */
