#ifndef OTC_COLLCTN_PRITERTR_HH
#define OTC_COLLCTN_PRITERTR_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     collctn/pritertr.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 TELSTRA CORPORATION LIMITED
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/collctn/prcursor.hh>

#ifdef __GNUG__
#if defined(EXPAND_TEMPLATES)
#pragma implementation "OTC/collctn/pritertr.hh"
#if (__GNUC__ >= 3 || __GNUC_MINOR__ >= 6) || defined(CXX_CYGNUS)
#pragma interface "OTC/collctn/pritertr.hh"
#else
#pragma interface
#endif
#endif
#endif

/* ------------------------------------------------------------------------- */

#ifdef __OSE_TEMPLATES__
template<class T1, class T2> OTC_PairIterator
{
  OSE_DECLARE OTC_PairCursor<T1,T2>;
};
#endif

template<class T1, class T2>
class OTC_PairIterator
    // = TITLE
    //     Interface to a cursor of a key/item pair.
    //
    // = CLASS TYPE
    //     Concrete
    //
    // = DESCRIPTION
    //     This class exists so that the user of an iterator for collections
    //     holding key/item pairs, does not have to worry about deleting the
    //     iterator when finished with it, nor need to know how to create an
    //     iterator for a specific type of collection. This class will ensure
    //     that the iterator is destroyed, when this class goes out of scope.
    //     In order for this to work correctly, an instance of this class
    //     should never be created using <new>.
{
  protected:

    T2&			_item() const
				{
				  OTCLIB_ENSURE((myIter != 0),
				   "OTC_PairIterator::_item() - Null iterator");
				  return myIter->item();
				}
				// Returns the item under the current
				// location of the iterator. Raises an
				// exception if there is no pair under the
				// iterator, or if this is a null iterator.

    OTC_PairCursor<T1,T2>*	_clone() const
				{ return myIter ? myIter->clone() : 0; }
				// Returns an iterator which is a clone of
				// this iterator. The new iterator will
				// initially be located over the same item as
				// this iterator, however subsequent
				// operations will be independent of this
				// iterator.

#if !defined(ENV_NOAPPLICATORS)

    void		_apply(OTC_PairVisitor<T1,T2>& theApplicator)
				{
				  OTC_PairCursor<T1,T2>::apply(myIter,
				   theApplicator);
				}
                                // Applies <theApplicator> to each key/item
                                // pair accessible by this iterator.

    void		_apply(OTC_PairWorker<T1,T2>& theApplicator)
				{
				  OTC_PairCursor<T1,T2>::apply(myIter,
				   theApplicator);
				}
                                // Applies <theApplicator> to each key/item
                                // pair accessible by this iterator.

#endif

  public:

			~OTC_PairIterator()
				{ OTC_PairCursor<T1,T2>::replace(myIter,0); }

    // = INITIALISATION

			OTC_PairIterator()
			  : myIter(0) {}
				// Creates a null iterator.

			OTC_PairIterator(OTC_PairCursor<T1,T2>* theIter)
				{
				  OTC_PairCursor<T1,T2>::assign(
				   myIter,theIter);
				}
				// Constructor used when an iterator
				// for a particular type of collection is
				// first created. Passing in <0> will
				// result in a nil iterator being
				// constructed.

			OTC_PairIterator(
			 OTC_PairIterator<T1,T2> const& theIter
			)
				{
				  OTC_PairCursor<T1,T2>::assign(
				   myIter,theIter.myIter);
				}
				// Copy constructor for when an iterator is
				// used as return type.

    OTC_PairIterator<T1,T2>&    operator=(OTC_PairCursor<T1,T2>* theIter)
				{
				  OTC_PairCursor<T1,T2>::replace(
				   myIter,theIter);
				  return *this;
				}
                                // Sets this iterator to <theIter>.
                                // If <theIter> is <0>, the iterator
                                // is turned into a null iterator and
                                // all associations with the previous
                                // collection are lost.

    OTC_PairIterator<T1,T2>&	operator=(
				 OTC_PairIterator<T1,T2> const& theIter
				)
				{
				  OTC_PairCursor<T1,T2>::replace(
				   myIter,theIter.myIter);
				  return *this;
				}
				// Sets this iterator to <theIter>.

    // = MOVEMENT

    void		next()
				{ if (myIter) myIter->next(); }
				// Moves the iterator to the next item.

    void		reset()
				{ if (myIter) myIter->reset(); }
				// Resets the iterator to the start.

    // = RETRIEVAL

    T1 const&		key() const
				{
				  OTCLIB_ENSURE((myIter != 0),
				   "OTC_PairIterator::key() - Null iterator");
				  return myIter->key();
				}
				// Returns the key under the current
				// location of the iterator. Raises an
				// exception if there is no pair under the
				// iterator, or if this is a null iterator.

    T2 const&		item() const
				{ return _item(); }
				// Returns the item under the current
				// location of the iterator. Raises an
				// exception if there is no pair under the
				// iterator, or if this is a null iterator.

    OTC_Boolean		isValid() const
				{
				  return myIter ?
				   myIter->isValid() : OTCLIB_FALSE;
				}
				// Returns <OTCLIB_TRUE> while there is a
				// valid data item under the current location
				// of the iterator.

    // = CLONING

    OTC_PairIterator<T1,T2>	clone() const
				{ return _clone(); }
				// Returns an iterator which is a clone of
				// this iterator. The new iterator will
				// initially be located over the same item as
				// this iterator, however subsequent
				// operations will be independent of this
				// iterator.

    // = APPLICATOR

#if !defined(ENV_NOAPPLICATORS)

    void		apply(OTC_PairVisitor<T1,T2>& theApplicator)
				{ _apply(theApplicator); }
                                // Applies <theApplicator> to each key/item
                                // pair accessible by this iterator.

#endif

  public:

#if defined(ENV_OSTORE)
    static os_typespec* get_os_typespec();
#endif

  private:

    OTC_PairCursor<T1,T2>*	myIter;
				// The real iterator.
};

/* ------------------------------------------------------------------------- */

#if defined(EXPAND_TEMPLATES)
#ifdef __OSE_TEMPLATES__
template<class T1, class T2> OTC_PairIterator
{
  OSE_IMPLEMENT OTC_PairCursor<T1,T2>;
};
#endif
#endif

/* ------------------------------------------------------------------------- */

#endif /* OTC_COLLCTN_PRITERTR_HH */
