#ifndef OTC_COLLCTN_PRMODIFR_HH
#define OTC_COLLCTN_PRMODIFR_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     collctn/prmodifr.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 TELSTRA CORPORATION LIMITED
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/collctn/pritertr.hh>

#ifdef __GNUG__
#if defined(EXPAND_TEMPLATES)
#pragma implementation "OTC/collctn/prmodifr.hh"
#if (__GNUC__ >= 3 || __GNUC_MINOR__ >= 6) || defined(CXX_CYGNUS)
#pragma interface "OTC/collctn/prmodifr.hh"
#else
#pragma interface
#endif
#endif
#endif

/* ------------------------------------------------------------------------- */

#ifdef __OSE_TEMPLATES__
template<class T1, class T2> OTC_PairModifier
{
  OSE_DECLARE OTC_PairIterator<T1,T2>;
};
#endif

template<class T1, class T2>
class OTC_PairModifier : public OTC_PairIterator<T1,T2>
    // = TITLE
    //     Interface to a cursor over a key/item pair.
    //
    // = CLASS TYPE
    //     Concrete
    //
    // = DESCRIPTION
    //     This class exists so that the user of an iterator for collections
    //     holding key/item pairs, does not have to worry about deleting the
    //     iterator when finished with it, nor need to know how to create an
    //     iterator for a specific type of collection. This class will ensure
    //     that the iterator is destroyed, when this class goes out of scope.
    //     In order for this to work correctly, an instance of this class
    //     should never be created using <new>. The difference between
    //     this class and <OTC_PairModifier> is that it is possible to
    //     modify the items through this class.
{
  public:

			~OTC_PairModifier() {}

    // = INITIALISATION

			OTC_PairModifier() {}
				// Creates a null iterator.

			OTC_PairModifier(OTC_PairCursor<T1,T2>* theIter)
			  : OTC_PairIterator<T1,T2>(theIter) {}
				// Constructor used when an iterator
				// for a particular type of collection is
				// first created. If <theIter> is <0> a
				// null iterator is constructed.

			OTC_PairModifier(
			 OTC_PairModifier<T1,T2> const& theIter
			)
			  : OTC_PairIterator<T1,T2>(theIter) {}
				// Copy constructor for when an iterator is
				// used as return type.

    OTC_PairModifier<T1,T2>&	operator=(OTC_PairCursor<T1,T2>* theIter)
				{
				  OTC_PairIterator<T1,T2>::operator=(theIter);
				  return *this;
				}
				// Sets this iterator to <theIter>.
				// If <theIter> is <0>, the iterator
				// is turned into a null iterator and
				// all associations with the previous
				// collection are lost.

    OTC_PairModifier<T1,T2>&	operator=(
				 OTC_PairModifier<T1,T2> const& theIter
				)
				{
				  OTC_PairIterator<T1,T2>::operator=(theIter);
				  return *this;
				}
				// Sets this iterator to <theIter>.

    // = RETRIEVAL

    T2&			item() const
				{ return _item(); }
				// Returns the item under the current
				// location of the iterator. If no such item
				// exists, or this is a null iterator, an
				// exception is raised.

    // = CLONING

    OTC_PairModifier<T1,T2>	clone() const
				{ return _clone(); }
				// Returns an iterator which is
                                // a clone of this iterator. The new
                                // iterator will initially be located
                                // over the same item as this iterator,
                                // however, subsequent operations will be
                                // independent of this iterator.

    // = APPLICATOR

#if !defined(ENV_NOAPPLICATORS)

    void		apply(OTC_PairVisitor<T1,T2>& theApplicator)
				{ _apply(theApplicator); }
				// Applies <theApplicator> to each key/item
				// pair accessible by this iterator.

    void		apply(OTC_PairWorker<T1,T2>& theApplicator)
				{ _apply(theApplicator); }
				// Applies <theApplicator> to each key/item
				// pair accessible by this iterator.

#endif

  public:

#if defined(ENV_OSTORE)
    static os_typespec* get_os_typespec();
#endif
};

#if defined(EXPAND_TEMPLATES)
#ifdef __OSE_TEMPLATES__
template<class T1, class T2> OTC_PairModifier
{
  OSE_IMPLEMENT OTC_PairIterator<T1,T2>;
};
#endif
#endif

/* ------------------------------------------------------------------------- */

#endif /* OTC_COLLCTN_PRMODIFR_HH */
