#ifndef OTC_COLLCTN_PRWORKER_HH
#define OTC_COLLCTN_PRWORKER_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     collctn/prworker.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 TELSTRA CORPORATION LIMITED
//     Copyright 1994 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/OTC.h>
#include <OTC/collctn/progress.hh>

#ifdef __GNUG__
#if defined(EXPAND_TEMPLATES)
#pragma implementation "OTC/collctn/prworker.hh"
#if (__GNUC__ >= 3 || __GNUC_MINOR__ >= 6) || defined(CXX_CYGNUS)
#pragma interface "OTC/collctn/prworker.hh"
#else
#pragma interface
#endif
#endif
#endif

/* ------------------------------------------------------------------------- */

template<class T1, class T2>
class OTC_PairWorker
    // = TITLE
    //     Abstract interface for objects which act on key/item pairs.
    //     
    // = CLASS TYPE
    //     Abstract
    //
    // = DESCRIPTION
    //     The <OTC_PairWorker> class provides an alternative to using the
    //     <OTC_PairModifier> class to act on key/item pairs in a collection.
    //     Support for the <OTC_PairWorker> class can also be provided on
    //     collection type objects which do not support an iterator.
    //     
    //     To use this concept, a derived version of this class must be
    //     created. The derived class must redefine the <action()> function
    //     to perform whatever is to be done for each key/item pair in
    //     the collection. An instance of the derived class is then applied
    //     to the collection. The collection will do the work of calling the
    //     <action()> function on each key/item pair in the collection. If
    //     necessary, the <action()> function, through is return value, can
    //     prematurely stop or restart the process.
    //
    //     Through the <OTC_PairWorker> class, it is possible to modify the
    //     item of the key/item pair to which the <action()> function is
    //     being applied. The key of the key/item pair may not be modified.
    //     
    // = NOTES
    //     The destructor of this class is <[NOT]> defined as virtual. The
    //     destructor is not defined as virtual so that a separate template
    //     expansion is not required for this class. The implication of the
    //     destructor not being virtual is that it is not possible to delete
    //     an instance of a derived class, which has been created on the free
    //     store, using a pointer to the base class. It is expected that
    //     instances of derived classes will always being created on the
    //     stack and thus this restriction should not affect the use of the
    //     class.
    //
    //     The <start()> and <finish()> functions are defined as being
    //     pure virtual functions and must be defined in a derived class.
    //     This requirement is again to avoid a separate template expansion
    //     of this class being required.
    //
    // = SEE ALSO
    //     <OTC_PairVisitor>
{
  public:

			OTC_PairWorker() {}

    // = STARTING/FINISHING

    virtual void	start() = 0;
                                // Called by a collection before the
                                // <action()> function is applied to any
                                // key/item pairs in the collection. This
                                // function must be defined in a derived
                                // class, even if the implementation will be
                                // empty.

    virtual void	finish() = 0;
                                // Called after the <action()> function has
                                // been applied to all key/item pairs in a
                                // collection, or if the return value of the
                                // <action()> function requested that
                                // traversal of key/item pairs in the
                                // collection be stopped. This function must
                                // be defined in a derived class, even if the
                                // implementation will be empty.

    // = ACTION

    virtual OTC_Progress	action(T1 const& theKey, T2& theItem) = 0;
                                // Called for each key/item pair in the
                                // collection. This function must be
                                // redefined in a derived class to perform
                                // whatever action is desired on <theKey> and
                                // <theItem>. The function must return either
                                // <OTCLIB_RESTART>, <OTCLIB_CONTINUE> or
                                // <OTCLIB_FINISH>. The value
                                // <OTCLIB_RESTART> should be returned if it
                                // is desired to start back at the beginning
                                // and go through each key/item pair again.
                                // The value <OTCLIB_FINISH> should be
                                // returned if it is desired to prematurely
                                // stop going through the key/item pairs. The
                                // value <OTCLIB_CONTINUE> should be returned
                                // if it is desired to move to the next
                                // key/item pair.

  private:

			OTC_PairWorker(OTC_PairWorker<T1,T2> const&)
				{ terminate(); }
				// Do not define an implementation for this.

    OTC_PairWorker<T1,T2>&	operator=(OTC_PairWorker<T1,T2> const&)
				{ terminate(); return *this; }
				// Do not define an implementation for this.
};

/* ------------------------------------------------------------------------- */

#endif /* OTC_COLLCTN_PRWORKER_HH */
