#ifndef OTC_COLLCTN_QUEUE_C
#define OTC_COLLCTN_QUEUE_C
/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     collctn/queue.c
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1992 1993 OTC LIMITED
//     Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/collctn/holder.hh>

#ifdef __OSE_TEMPLATES__
template<class T> OTC_Queue
{
  OSE_TEMPLATE OTC_Holder<T>;
};
#endif

/* ------------------------------------------------------------------------- */
template<class T>
OTC_Queue<T>::OTC_Queue()
  : myCount(0)
{
#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
#endif

#if defined(ENV_OSTORE_DML)
  myList = new ((os_segment*)theLocality) OTC_LinkList;
#else
#if defined(ENV_OSTORE)
    myList = new (theLocality,OTC_LinkList::get_os_typespec()) OTC_LinkList;
#else
  myList = new OTC_LinkList;
#endif
#endif
  OTCLIB_ASSERT(myList != 0);
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_Queue<T>::OTC_Queue(OTC_Queue<T> const& theQueue)
  : myCount(0)
{
#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
#endif

#if defined(ENV_OSTORE_DML)
  myList = new ((os_segment*)theLocality) OTC_LinkList;
#else
#if defined(ENV_OSTORE)
  myList = new (theLocality,OTC_LinkList::get_os_typespec()) OTC_LinkList;
#else
  myList = new OTC_LinkList;
#endif
#endif
  OTCLIB_ASSERT(myList != 0);

  OTC_LinkIterator iter = theQueue.myList->items(OTCLIB_UNSAFE);
  for (iter.resetFirst(); iter.isLink(); iter.next())
    add(((OTC_Holder<T>*)iter.link())->item());
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_Queue<T>& OTC_Queue<T>::operator=(OTC_Queue<T> const& theQueue)
{
  if (&theQueue == this)
    return *this;

  clear();

  OTC_LinkIterator iter = theQueue.myList->items(OTCLIB_UNSAFE);
  for (iter.resetFirst(); iter.isLink(); iter.next())
    add(((OTC_Holder<T>*)iter.link())->item());

  return *this;
}

/* ------------------------------------------------------------------------- */
template<class T>
void OTC_Queue<T>::add(T const& theItem)
{
#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
#endif

  OTC_Holder<T>* theNode;
#if defined(ENV_OSTORE_DML)
  theNode = new ((os_segment*)theLocality) OTC_Holder<T>(theItem);
#else
#if defined(ENV_OSTORE)
  theNode = new (theLocality,OTC_Holder<T>::get_os_typespec())
   OTC_Holder<T>(theItem);
#else
  theNode = new OTC_Holder<T>(theItem);
#endif
#endif
  OTCLIB_ASSERT(theNode != 0);
  myList->addLast(theNode);
  myCount++;
}

/* ------------------------------------------------------------------------- */
template<class T>
T OTC_Queue<T>::remove()
{
  OTCLIB_ENSURE((!isEmpty()),
   "OTC_Queue::remove() - Queue empty");

  OTC_Holder<T>* theNode = (OTC_Holder<T>*)myList->first();
  T theItem = theNode->item();
  theNode->kill();
  myCount--;
  return theItem;
}

/* ------------------------------------------------------------------------- */
template<class T>
void OTC_Queue<T>::discard(u_int theCount)
{
  OTCLIB_ENSURE((theCount <= myCount),
   "OTC_Queue::discard() - Insufficient items");
  while (theCount > 0)
  {
    myList->first()->kill();
    theCount--;
    myCount--;
  }
}

/* ------------------------------------------------------------------------- */
template<class T>
T& OTC_Queue<T>::_head() const
{
  OTCLIB_ENSURE((!isEmpty()),
   "OTC_Queue::_head() - Queue empty");

  OTC_Holder<T>* theNode = (OTC_Holder<T>*)myList->first();
  return theNode->item();
}

/* ------------------------------------------------------------------------- */

#endif /* OTC_COLLCTN_QUEUE_C */
