#ifndef OTC_COLLCTN_SINGLE_HH
#define OTC_COLLCTN_SINGLE_HH
/*
// ============================================================================
//
// = LIBRARY
//     OTC
// 
// = FILENAME
//     collctn/single.hh
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1993 TELSTRA CORPORATION LIMITED
//     Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/memory/mpobject.hh>

#ifdef __GNUG__
#if defined(EXPAND_TEMPLATES)
#pragma implementation "OTC/collctn/single.hh"
#if (__GNUC__ >= 3 || __GNUC_MINOR__ >= 6) || defined(CXX_CYGNUS)
#pragma interface "OTC/collctn/single.hh"
#else
#pragma interface
#endif
#endif
#endif

/* ------------------------------------------------------------------------- */

template<class T>
class OTC_Single : public OTC_MPObject
    // = TITLE
    //     Template class for encapsulating a single value.
    //
    // = CLASS TYPE
    //     Concrete
    //
    // = DESCRIPTION
    //     The <OTC_Single> class can be used to encapsulate a single item.
    //     This class is generally only useful where you want to ensure
    //     that an object is allocated from the common memory pool rather
    //     than the normal free store. Multi valued variants of this class
    //     are available in the form of the <OTC_Pair> and <OTC_Triple>
    //     classes.
    //
    // = NOTES
    //     Naming of member functions is to be consistant with multi
    //     valued variants of this class.
    //
    // = SEE ALSO
    //     <OTC_Pair>, <OTC_Triple>
{
  public:

    // = INITIALISATION

			OTC_Single(T const& theFirst)
			  : myFirst(theFirst)
				{}
				// Sets the values of this class to <theFirst>.

			OTC_Single(OTC_Single<T> const& theSingle)
			  : myFirst(theSingle.myFirst)
				{}
				// Sets the value of this class to that
				// of <theSingle>.

    // = ASSIGNMENT

    OTC_Single<T>&	operator=(OTC_Single<T> const& theSingle)
				{
				  myFirst = theSingle.myFirst;
				  return *this;
				}
				// Sets the value of this class to that
				// of <theSingle>.

    // = ACCESS

    T const&		first() const
				{ return myFirst; }
				// Returns the value of this class.

    T&			first()
				{ return myFirst; }
				// Returns the value of this class.

  public:

#if defined(ENV_OSTORE)
    static os_typespec* get_os_typespec();
#endif

  private:

    T			myFirst;
				// Value held by this class.
};

/* ------------------------------------------------------------------------- */

#endif /* OTC_COLLCTN_SINGLE_HH */
