#ifndef OTC_COLLCTN_STACK_C
#define OTC_COLLCTN_STACK_C
/*
// ============================================================================
//
// = LIBRARY
//     OTC
//
// = FILENAME
//     collctn/stack.c
//
// = AUTHOR(S)
//     Graham Dumpleton
// 
// = COPYRIGHT
//     Copyright 1992 1993 OTC LIMITED
//     Copyright 1995 DUMPLETON SOFTWARE CONSULTING PTY LIMITED
//
// ============================================================================
*/

#include <OTC/collctn/holder.hh>

#ifdef __OSE_TEMPLATES__
template<class T> OTC_Stack
{
  OSE_TEMPLATE OTC_Holder<T>;
};
#endif

/* ------------------------------------------------------------------------- */
template<class T>
OTC_Stack<T>::OTC_Stack()
  : myCount(0)
{
#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
#endif

#if defined(ENV_OSTORE_DML)
  myList = new ((os_segment*)theLocality) OTC_LinkList;
#else
#if defined(ENV_OSTORE)
  myList = new (theLocality,OTC_LinkList::get_os_typespec()) OTC_LinkList;
#else
  myList = new OTC_LinkList;
#endif
#endif
  OTCLIB_ASSERT(myList != 0);
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_Stack<T>::OTC_Stack(OTC_Stack<T> const& theStack)
  : myCount(0)
{
#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
#endif

#if defined(ENV_OSTORE_DML)
  myList = new ((os_segment*)theLocality) OTC_LinkList;
#else
#if defined(ENV_OSTORE)
  myList = new (theLocality,OTC_LinkList::get_os_typespec()) OTC_LinkList;
#else
  myList = new OTC_LinkList;
#endif
#endif
  OTCLIB_ASSERT(myList != 0);

  OTC_LinkIterator iter = theStack.myList->items(OTCLIB_UNSAFE);
  for (iter.resetLast(); iter.isLink(); iter.prev())
    push(((OTC_Holder<T>*)iter.link())->item());
}

/* ------------------------------------------------------------------------- */
template<class T>
OTC_Stack<T>& OTC_Stack<T>::operator=(OTC_Stack<T> const& theStack)
{
  if (&theStack == this)
    return *this;

  clear();

  OTC_LinkIterator iter = theStack.myList->items(OTCLIB_UNSAFE);
  for (iter.resetLast(); iter.isLink(); iter.prev())
    push(((OTC_Holder<T>*)iter.link())->item());

  return *this;
}

/* ------------------------------------------------------------------------- */
template<class T>
void OTC_Stack<T>::push(T const& theItem)
{
#if defined(ENV_OSTORE_DML) || defined(ENV_OSTORE)
  OTC_Locality theLocality = OTC_Locality::of(this);
#endif

  OTC_Holder<T>* theNode;
#if defined(ENV_OSTORE_DML)
  theNode = new ((os_segment*)theLocality) OTC_Holder<T>(theItem);
#else
#if defined(ENV_OSTORE)
  theNode = new (theLocality,OTC_Holder<T>::get_os_typespec())
   OTC_Holder<T>(theItem);
#else
  theNode = new OTC_Holder<T>(theItem);
#endif
#endif
  OTCLIB_ASSERT(theNode != 0);
  myList->addFirst(theNode);
  myCount++;
}

/* ------------------------------------------------------------------------- */
template<class T>
T OTC_Stack<T>::pop()
{
  OTCLIB_ENSURE((!isEmpty()),
   "OTC_Stack::pop() - Stack empty");

  OTC_Holder<T>* theNode = (OTC_Holder<T>*)myList->first();
  T theItem = theNode->item();
  theNode->kill();
  myCount--;
  return theItem;
}

/* ------------------------------------------------------------------------- */
template<class T>
void OTC_Stack<T>::discard(u_int theCount)
{
  OTCLIB_ENSURE((theCount <= myCount),
   "OTC_Stack::discard() - Insufficient items");

  while (theCount > 0)
  {
    myList->first()->kill();
    theCount--;
    myCount--;
  }
}

/* ------------------------------------------------------------------------- */
template<class T>
T& OTC_Stack<T>::_top() const
{
  OTCLIB_ENSURE((!isEmpty()),
   "OTC_Stack::_top() - Stack empty");

  OTC_Holder<T>* theNode = (OTC_Holder<T>*)myList->first();
  return theNode->item();
}

/* ------------------------------------------------------------------------- */

#endif /* OTC_COLLCTN_STACK_C */
